% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compatibility.R
\name{rforcecom.bulkAction}
\alias{rforcecom.bulkAction}
\title{Run Bulk Action}
\usage{
rforcecom.bulkAction(
  session,
  operation = c("insert", "delete", "upsert", "update", "hardDelete"),
  data,
  object,
  external_id_fieldname = NULL,
  multiBatch = TRUE,
  batchSize = 10000,
  interval_seconds = 5,
  max_attempts = 100,
  verbose = FALSE
)
}
\arguments{
\item{session}{a named character vector defining parameters of the api connection as returned by \link{rforcecom.login}}

\item{operation}{a character string defining the type of operation being performed}

\item{data}{a matrix or data.frame that can be coerced into .csv file for submitting as batch request}

\item{object}{a character string defining the target salesforce object that the operation will be performed on}

\item{external_id_fieldname}{character; string identifying a custom field on the 
object that has been set as an "External ID" field. This field is used to reference 
objects during upserts to determine if the record already exists in Salesforce or not.}

\item{multiBatch}{a boolean value defining whether or not submit data in batches to the api}

\item{batchSize}{an integer value defining the number of records to submit if multiBatch is true.
The max value is 10000 in accordance with salesforce limits.}

\item{interval_seconds}{an integer defining the seconds between attempts to check for job completion}

\item{max_attempts}{an integer defining then max number attempts to check for job completion before stopping}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{tbl_df} of the results of the bulk job
}
\description{
This function is a convenience wrapper for submitting bulk API jobs
}
\examples{
\dontrun{
# update Account object
updates <- rforcecom.bulkAction(session, operation='update', data=my_data, object='Account')
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/}
}
