% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bulk-query.R
\name{sf_query_bulk}
\alias{sf_query_bulk}
\title{Run Bulk Query}
\usage{
sf_query_bulk(
  soql,
  object_name = NULL,
  queryall = FALSE,
  guess_types = TRUE,
  api_type = c("Bulk 1.0"),
  interval_seconds = 5,
  max_attempts = 100,
  control = list(...),
  ...,
  verbose = FALSE
)
}
\arguments{
\item{soql}{character; a string defining a SOQL query (e.g. "SELECT Id, Name FROM Account")}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{queryall}{logical; indicating if the query recordset should include records 
that have been deleted because of a merge or delete. QueryAll will also return 
information about archived Task and Event records. QueryAll is available in API 
version 29.0 and later.}

\item{guess_types}{logical; indicating whether or not to use \code{col_guess()} 
to try and cast the data returned in the query recordset. TRUE uses \code{col_guess()} 
and FALSE returns all values as character strings.}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{interval_seconds}{integer; defines the seconds between attempts to check 
for job completion}

\item{max_attempts}{integer; defines then max number attempts to check for job 
completion before stopping}

\item{control}{\code{list}; a list of parameters for controlling the behavior of 
the API call being used. For more information of what parameters are available 
look at the documentation for \code{\link{sf_control}}}

\item{...}{arguments passed to \code{\link{sf_control}}}

\item{verbose}{logical; do you want informative messages?}
}
\value{
A \code{tbl_df} of the recordset returned by the query
}
\description{
This function is a convenience wrapper for submitting and retrieving 
bulk query API jobs
}
\examples{
\dontrun{
# select all Ids from Account object (up to 1000)
ids <- sf_query_bulk(soql = 'SELECT Id FROM Account LIMIT 1000', 
                     object_name = 'Account')
}
}
\references{
\url{https://developer.salesforce.com/docs/atlas.en-us.api_asynch.meta/api_asynch/asynch_api_bulk_query_intro.htm}
}
