% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/upsert.R
\name{sf_upsert}
\alias{sf_upsert}
\title{Upsert Records}
\usage{
sf_upsert(
  input_data,
  object_name,
  external_id_fieldname,
  api_type = c("SOAP", "REST", "Bulk 1.0", "Bulk 2.0"),
  control = list(...),
  ...,
  verbose = FALSE
)
}
\arguments{
\item{input_data}{\code{named vector}, \code{matrix}, \code{data.frame}, or 
\code{tbl_df}; data can be coerced into a \code{data.frame}}

\item{object_name}{character; the name of one Salesforce objects that the 
function is operating against (e.g. "Account", "Contact", "CustomObject__c")}

\item{external_id_fieldname}{character; string identifying a custom field on the 
object that has been set as an "External ID" field. This field is used to reference 
objects during upserts to determine if the record already exists in Salesforce or not.}

\item{api_type}{character; one of "REST", "SOAP", "Bulk 1.0", "Bulk 2.0", or 
"Chatter" indicating which API to use when making the request}

\item{control}{\code{list}; a list of parameters for controlling the behavior of 
the API call being used. For more information of what parameters are available 
look at the documentation for \code{\link{sf_control}}}

\item{...}{arguments passed to \code{\link{sf_control}} or further downstream 
to \code{\link{sf_bulk_operation}}}

\item{verbose}{logical; do you want informative messages?}
}
\value{
\code{tbl_df} of records with success indicator
}
\description{
Upserts one or more new records to your organization’s data.
}
\examples{
\dontrun{
n <- 2
new_contacts <- tibble(FirstName = rep("Test", n),
                       LastName = paste0("Contact-Create-", 1:n),
                       My_External_Id__c=letters[1:n])
new_contacts_result <- sf_create(new_contacts, object_name="Contact")

upserted_contacts <- tibble(FirstName = rep("Test", n),
                            LastName = paste0("Contact-Upsert-", 1:n),
                            My_External_Id__c=letters[1:n])
new_record <- tibble(FirstName = "Test",
                     LastName = paste0("Contact-Upsert-", n+1),
                     My_External_Id__c=letters[n+1])
upserted_contacts <- bind_rows(upserted_contacts, new_record)

upserted_contacts_result1 <- sf_upsert(upserted_contacts, 
                                       object_name="Contact", 
                                       "My_External_Id__c")
}
}
