% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attachments.R
\name{sf_update_attachment}
\alias{sf_update_attachment}
\title{Update Attachments}
\usage{
sf_update_attachment(
  attachment_input_data,
  object_name = c("Attachment"),
  api_type = c("SOAP", "REST", "Bulk 1.0", "Bulk 2.0"),
  control = list(...),
  ...,
  verbose = FALSE
)
}
\arguments{
\item{attachment_input_data}{\code{named vector}, \code{matrix},
\code{data.frame}, or \code{tbl_df}; data can be coerced into a
\code{data.frame}. The input must contain a column entitled 'Body' with an
absolute or relative file path (unless creating a Document using a Url)
along with other required fields depending on the object.If performing an
\code{update} operation, then one column or field of the input must be
the \code{Id} of the record to modify.}

\item{object_name}{\code{character}; the name of the Salesforce object that the
function is operating against (e.g. "Account", "Contact", "CustomObject__c").}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{control}{\code{list}; a list of parameters for controlling the behavior of
the API call being used. For more information of what parameters are available
look at the documentation for \code{\link{sf_control}}.}

\item{...}{arguments passed to \code{\link{sf_control}} or further downstream
to \code{\link{sf_bulk_operation}}}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{tbl_df} with details of the created records
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function will allow you to update attachments (and other blob data, such as
Documents) by providing the Id of the attachment record and the file paths
(absolute or relative) to media that you would like to upload to Salesforce
along with other supported metadata for this operation (\code{Name},
\code{Body}, \code{IsPrivate}, and \code{OwnerId}).
}
\note{
The length of any file name can’t exceed 512 bytes (per Bulk 1.0 API).
The SOAP API create call restricts these files to a maximum size of 25 MB. For a file
attached to a Solution, the limit is 1.5 MB. The maximum email attachment size is 3 MB.
You can only create or update documents to a maximum size of 5 MB. The REST API
allows you to insert or update blob data limited to 50 MB of text data or 37.5 MB
of base64–encoded data.
}
\section{Salesforce Documentation}{

\itemize{
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api.meta/api/sforce_api_objects_attachment.htm}{Attachment Object (SOAP)}
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api.meta/api/sforce_api_objects_document.htm}{Document Object (SOAP)}
\item \href{https://developer.salesforce.com/docs/atlas.en-us.api_rest.meta/api_rest/dome_sobject_insert_update_blob.htm}{Insert or Update Blob Data}
}
}

\examples{
\dontrun{
# upload a PDF to a particular record as an Attachment
file_path <- system.file("extdata",
                         "data-wrangling-cheatsheet.pdf",
                         package = "salesforcer")
parent_record_id <- "0036A000002C6MmQAK" # replace with your own ParentId!
attachment_details <- tibble(Body = file_path, ParentId = parent_record_id)
create_result <- sf_create_attachment(attachment_details)

# download, zip, and re-upload the PDF
pdf_path <- sf_download_attachment(sf_id = create_result$id[1])
zipped_path <- paste0(pdf_path, ".zip")
zip(zipped_path, pdf_path)
attachment_details <- tibble(Id = create_result$id, Body = zipped_path)
update_result <- sf_update_attachment(attachment_details)
}
}
\seealso{
Other Attachment functions: 
\code{\link{check_and_encode_files}()},
\code{\link{sf_create_attachment}()},
\code{\link{sf_delete_attachment}()},
\code{\link{sf_download_attachment}()}
}
\concept{Attachment functions}
