% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete-metadata.R
\name{sf_delete_metadata}
\alias{sf_delete_metadata}
\title{Delete Object or Field Metadata in Salesforce}
\usage{
sf_delete_metadata(
  metadata_type,
  object_names,
  control = list(...),
  ...,
  all_or_none = deprecated(),
  verbose = FALSE
)
}
\arguments{
\item{metadata_type}{\code{character}; string on what type of metadata to create.}

\item{object_names}{a character vector of names that we wish to read metadata for}

\item{control}{\code{list}; a list of parameters for controlling the behavior of
the API call being used. For more information of what parameters are available
look at the documentation for \code{\link{sf_control}}.}

\item{...}{arguments passed to \code{\link{sf_control}}}

\item{all_or_none}{\code{logical}; allows a call to roll back all changes unless all
records are processed successfully.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
A \code{data.frame} containing the creation result for each submitted metadata component
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function takes a request of named elements in Salesforce and deletes them.
}
\examples{
\dontrun{
metadata_info <- sf_delete_metadata(metadata_type = 'CustomObject', 
                                    object_names = c('Custom_Account25__c'))
}
}
\seealso{
\code{\link{sf_list_metadata}}, \href{https://developer.salesforce.com/docs/atlas.en-us.api_meta.meta/api_meta}{Salesforce Documentation}
}
