% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-same-text.R
\name{same_text}
\alias{same_text}
\title{Compare Text Similarity Across Lists}
\usage{
same_text(
  ...,
  method = c("osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw",
    "soundex"),
  q = 1,
  p = NULL,
  bt = 0,
  weight = c(d = 1, i = 1, s = 1, t = 1),
  digits = 3
)
}
\arguments{
\item{...}{Lists of character strings to compare}

\item{method}{Character vector of similarity methods from \code{stringdist}. Choose from:
"osa", "lv", "dl", "hamming", "lcs", "qgram", "cosine", "jaccard", "jw", "soundex"
(default: all)}

\item{q}{Size of q-gram for q-gram based methods (default: 1)}

\item{p}{Winkler scaling factor for "jw" method (default: 0.1)}

\item{bt}{Booth matching threshold}

\item{weight}{Vector of weights for operations: deletion (d), insertion (i),
substitution (s), transposition (t)}

\item{digits}{Number of digits to round results (default: 3)}
}
\value{
An S3 class object of type "similar_text" containing:
\itemize{
\item scores: Numeric similarity scores by method and comparison
\item summary: Summary statistics by method and comparison
\item methods: Methods used for comparison
\item list_names: Names of compared lists
}
}
\description{
Compare Text Similarity Across Lists
}
\examples{
list1 <- list("hello", "world")
list2 <- list("helo", "word")
result <- same_text(list1, list2)
}
