% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bivdiff_Plot.R
\name{heatmap_biv_compare}
\alias{heatmap_biv_compare}
\title{Plot Difference or Relative Difference in Pearson's r for Multiple Data Frames}
\usage{
heatmap_biv_compare(
  biv_data_object,
  value = "AAB",
  summet_transparance = 0,
  summetric = TRUE,
  summet_size = 4.5,
  ndigits_summet = 3,
  upper_limit = NULL,
  lower_limit = NULL,
  corr_size = 3,
  ndigits_number = 2,
  varlabels = NULL,
  plots_label = NULL,
  grid = "white",
  colors = c("#8ECCEE", "#1F45F9"),
  number_color = "white",
  ncol_facet = 3,
  legend_title = NULL,
  interest_breaks = NULL,
  interest_labels = NULL,
  plot_title = NULL
)
}
\arguments{
\item{biv_data_object}{A object generated by the \link{biv_compare} function.}

\item{value}{A character string which is either \code{"AAB"} or  \code{"AARB"}.
AAB means that the Absolute Difference in Pearson's r estimates between dfs
and the benchmarks should be displayed in the tiles by number and color. AARB
means that the Absolute Relative Difference should be displayed instead.}

\item{summet_transparance}{A number to determine the transparency of the
displayed \code{summetric}.}

\item{summetric}{If \code{TRUE} Average Absolute Difference (AAB) and the
Average Absolute Relative Difference (AARB) of Pearson's r values between the
\code{dfs} and the \code{benchmarks} is displayed in the plot.}

\item{summet_size}{A number to determine the size of the displayed
\code{summetric} in the plot.}

\item{ndigits_summet}{The maximum number of digits for numbers displayed in the summertic of the plot.}

\item{upper_limit, lower_limit}{A numeric value, indicating the highest or lowest
value that should be displayed in the tiles by number and color. This does
not affect the \code{summetric}. However, it can be used to keep differences
between values visible in the heatmap, even in the presence of strong ouliers.}

\item{corr_size}{The font size of correlation numbers displayed in the tiles of the heatmap.}

\item{ndigits_number}{The maximum digits of numbers displyed in the tiles of the
heatmap.}

\item{varlabels}{A character string or vector of character strings containing
the new labels of variables that are used in the plot.}

\item{plots_label}{A character string or vector of character strings
containing the new labels of the data frames that are used in the plot.}

\item{grid}{A character string, that determines the color of the lines
between the tiles of the heatmap.}

\item{colors}{A vector of two colors used in the heatmap.}

\item{number_color}{A character string indicating the color of the numbers,
displayed in the tiles.}

\item{ncol_facet}{Number of columns used in faced_wrap() for the plots.}

\item{legend_title}{A character string indicating the title of the legend of the plot.}

\item{interest_breaks}{A numeric vector indicating the breaks for the color scheme
displayed in the legend of the heatmap.}

\item{interest_labels}{A character vector indicating the labels for the breaks
displayed in the legend of the heatmap.}

\item{plot_title}{A character string containing the title of the plot.}
}
\value{
A object generated with the help of \code{\link[ggplot2:ggplot2-package]{ggplot2::ggplot2()}}, used to visualize
a heatmap of the bivariate differences between the data frames and benchmarks.
}
\description{
Plot a object generated by \link{biv_compare} function as a heatmap.
}
\details{
The plot shows a heatmap of a correlation matrix, where the colors are determined by
the Absolue Difference or the Absolute Relative Difference in Pearson's r estimates
between the data frames and the benchmarks.
}
\examples{

## Get Data for comparison

data("card")

north <- card[card$south==0,]
white <- card[card$black==0,]

## use the function to plot the data 
bivar_data<-sampcompR::biv_compare(dfs = c("north","white"),
                                   benchmarks = c("card","card"),
                                   variables= c("age","educ","fatheduc","motheduc","wage","IQ"),
                                   data=TRUE)

Absolute_Bias_Plot<-sampcompR::heatmap_biv_compare(bivar_data,value = "AAB")
Absolute_Bias_Plot

Absolute_Relative_Bias_Plot<-sampcompR::heatmap_biv_compare(bivar_data,value = "AARB")
Absolute_Relative_Bias_Plot


}
