% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ss4pLN.R
\name{ss4pLN}
\alias{ss4pLN}
\title{The required sample size for estimating a single proportion based on a logaritmic transformation of the estimated proportion}
\usage{
ss4pLN(N, P, DEFF = 1, cve = 0.05, plot = FALSE)
}
\arguments{
\item{N}{The population size.}

\item{P}{The value of the estimated proportion.}

\item{DEFF}{The design effect of the sample design. By default \code{DEFF = 1}, which corresponds to a simple random sampling design.}

\item{cve}{The maximun coeficient of variation that can be allowed for the estimation.}

\item{plot}{Optionally plot the errors (cve and margin of error) against the sample size.}
}
\description{
This function returns the minimum sample size required for estimating a single proportion subjecto to predefined errors.
}
\details{
As for low proportions, the coefficient of variation tends to infinity, it is customary to use
a simmetrycal transformation of this measure (based on the relative standard error RSE) to report
the uncertainity of the estimation. This way, if \eqn{p \leq 0.5}, the transformed CV will be:
\deqn{RSE(-ln(p))= \frac{SE(p)}{-ln(p)*p}}
Otherwise, when \eqn{p > 0.5}, the transformed CV will be:
\deqn{RSE(-ln(1-p))= \frac{SE(p)}{-ln(1-p)*(1-p)}}
Note that, when \eqn{p \leq 0.5} the minimun sample size to achieve a particular coefficient of variation \eqn{cve} is defined by:
\deqn{n = \frac{S^2}{P^2cve^2+\frac{S^2}{N}}}
When \eqn{p > 0.5} the minimun sample size to achieve a particular coefficient of variation \eqn{cve} is defined by:
\deqn{n = \frac{S^2}{P^2cve^2+\frac{S^2}{N}}}
}
\examples{
ss4pLN(N=10000, P=0.8, cve=0.10)
ss4pLN(N=10000, P=0.2, cve=0.10)
ss4pLN(N=10000, P=0.7, cve=0.05, plot=TRUE)
ss4pLN(N=10000, P=0.3, cve=0.05, plot=TRUE)
ss4pLN(N=10000, P=0.05, DEFF=3.45, cve=0.03, plot=TRUE)
ss4pLN(N=10000, P=0.95, DEFF=3.45, cve=0.03, plot=TRUE)

##########################
# Example with Lucy data #
##########################

data(Lucy)
attach(Lucy)
N <- nrow(Lucy)
P <- prop.table(table(SPAM))[1]
# The minimum sample size for simple random sampling
ss4pLN(N, P, DEFF=1, cve=0.03, plot=TRUE)
# The minimum sample size for a complex sampling design
ss4pLN(N, P, DEFF=3.45, cve=0.03, plot=TRUE)
}
\references{
Gutierrez, H. A. (2009), \emph{Estrategias de muestreo: Diseno de encuestas y estimacion de parametros}. Editorial Universidad Santo Tomas
}
\seealso{
\code{\link{ss4p}}
}
\author{
Hugo Andres Gutierrez Rojas <hugogutierrez at usantotomas.edu.co>
}
