% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_functions.R
\name{calc_PSD}
\alias{calc_PSD}
\title{Power Spectral Density Calculator}
\usage{
calc_PSD(chain, plot = FALSE)
}
\arguments{
\item{chain}{Matrix of n x d dimensions, n = iterations, d = dimensions sequence}

\item{plot}{Boolean. Whether to return a plot or the elements used to make it.}
}
\value{
Returns a list with log frequencies, log PSDs, and slope and intercept estimates.
}
\description{
This function estimates the log power spectral density against the log frequency, and calculates a slope \eqn{\alpha}.
}
\details{
A number of studies have reported that cognitive activities contain a long-range slowly decaying autocorrelation. In the frequency domain, this is expressed as \eqn{S(f)} ~  \eqn{1/f^{-\alpha}}, with \eqn{f} being frequency, \eqn{S(f)} being spectral power, and \eqn{\alpha} \eqn{\epsilon} \eqn{[0.5,1.5]} is considered \eqn{1/f} scaling. See See \insertCite{zhu2018MentalSamplingMultimodal;textual}{samplr} for a comparison of Levy Flight and PSD measures for different samplers in multimodal representations.
}
\examples{
set.seed(1)
chain1 <- sampler_mh(1, "norm", c(0,1), diag(1))
calc_PSD(chain1[[1]], plot= TRUE)
}
\references{
\insertAllCited{}
}
