# This is package documentation for sandwichr.
# roxygen will use this file to create a NAMESPACE file.
# Of importance is the @import command, as it lists package dependencies.

#' \code{sandwichr}: Spatial Interpolation Based on Spatial Stratified Heterogeneity
#'
#' The package \code{sandwichr} provides tools to interpolate a spatially stratified heterogeneous population with high accuracy, even when its spatial autocorrelation is weak. These tools allow the calculation of critical summarized statistics such as geodetector \emph{q}. They also enable the visualization of the interpolated surface as well as the standard error and confidence interval maps.
#'
#' @author Yue Lin, Chengdong Xu, and Jinfeng Wang
#'
#' @references
#' Wang, J. F., Haining, R., Liu, T. J., Li, L. F., & Jiang, C. S. (2013). Sandwich estimation for multi-unit reporting on a stratified heterogeneous surface. \emph{Environment and Planning A}, 45(10), 2515-2534.
#'
#' @docType package
#' @name sandwichr
NULL
