% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df_search.R
\name{plot_param_evolution}
\alias{plot_param_evolution}
\title{Plot the evolution of different fitting parameters across all possible df for each eigenSpline}
\usage{
plot_param_evolution(paramSpace, scaled = FALSE)
}
\arguments{
\item{paramSpace}{A list of \emph{n} matrices (\emph{n} being the number or eigenSplines) as generated by \code{\link{plot_param_evolution}}. Each matrix  of fitting parameters has as rows different fitting metrics, as columns different \emph{df} values.}

\item{scaled}{(bool) If TRUE, the value of each eigenSpline fitting parameter are scaled between 0 and 1. Default is TRUE.}
}
\value{
A list of \code{ggplot2} plotObjects, one plot per fitting parameters. All results can be plotted using \code{do.call(grid.arrange, returnedResult)}
}
\description{
Plot the evolution of 5 different fitting metrics (\emph{\strong{CV}: Cross-Validation, \strong{GCV}: Generalised Cross-Validation, \strong{AIC}: Akaike Information Criterion, \strong{BIC}: Bayesian Information Criterion, \strong{AICc}: Akaike Information Criterion Corrected for small sample size}) over all possible \emph{df} for each eigenSpline generated by \code{\link{get_param_evolution}}.
}
\examples{
## 8 subjects, 4 time-points, 3 variables
inputData  <- acuteInflammation$data[0:32,1:3]
ind        <- acuteInflammation$meta$ind[0:32]
time       <- acuteInflammation$meta$time[0:32]
eigen      <- get_eigen_spline(inputData, ind, time, nPC=NA, scaling="scaling_UV",
                               method="nipals", verbose=TRUE, centering=TRUE, ncores=0)
paramSpace <- get_param_evolution(eigen, step=0.25)
plotList   <- plot_param_evolution(paramSpace, scaled=TRUE)
plotList[1]
#do.call(grid.arrange, plotList )

}
\seealso{
Graphical implementation with \code{\link{santaR_start_GUI}}

Other DFsearch: 
\code{\link{get_eigen_DFoverlay_list}()},
\code{\link{get_eigen_DF}()},
\code{\link{get_eigen_spline}()},
\code{\link{get_param_evolution}()},
\code{\link{plot_nbTP_histogram}()}
}
\concept{DFsearch}
