% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R, R/breaks.R, R/tab.R
\name{chop_mean_sd}
\alias{chop_mean_sd}
\alias{brk_mean_sd}
\alias{tab_mean_sd}
\title{Chop by standard deviations}
\usage{
chop_mean_sd(x, sds = 1:3, ..., sd = deprecated())

brk_mean_sd(sds = 1:3, sd = deprecated())

tab_mean_sd(x, sds = 1:3, ...)
}
\arguments{
\item{x}{A vector.}

\item{sds}{Positive numeric vector of standard deviations.}

\item{...}{Passed to \code{\link[=chop]{chop()}}.}

\item{sd}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
\verb{chop_*} functions return a \code{\link{factor}} of the same length as \code{x}.

\verb{brk_*} functions return a \code{\link{function}} to create \code{breaks}.

\verb{tab_*} functions return a contingency \code{\link[=table]{table()}}.
}
\description{
Intervals are measured in standard deviations on either side of the
mean.
}
\details{
In version 0.7.0, these functions changed to specifying \code{sds} as a vector.
To chop 1, 2 and 3 standard deviations around the mean, write
\code{chop_mean_sd(x, sds = 1:3)} instead of \code{chop_mean_sd(x, sd = 3)}.
}
\examples{
chop_mean_sd(1:10)

chop(1:10, brk_mean_sd())

tab_mean_sd(1:10)

}
\seealso{
Other chopping functions: 
\code{\link{chop_equally}()},
\code{\link{chop_evenly}()},
\code{\link{chop_n}()},
\code{\link{chop_proportions}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{chop}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
