% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R, R/breaks.R, R/tab.R
\name{chop_equally}
\alias{chop_equally}
\alias{brk_equally}
\alias{tab_equally}
\title{Chop equal-sized groups}
\usage{
chop_equally(
  x,
  groups,
  ...,
  labels = lbl_intervals(),
  left = is.numeric(x),
  close_end = TRUE,
  raw = TRUE
)

brk_equally(groups)

tab_equally(x, groups, ..., left = is.numeric(x), raw = TRUE)
}
\arguments{
\item{x}{A vector.}

\item{groups}{Number of groups.}

\item{...}{Passed to \code{\link[=chop]{chop()}}.}

\item{labels}{A character vector of labels or a function to create labels.}

\item{left}{Logical. Left-closed or right-closed breaks?}

\item{close_end}{Logical. Close last break at right? (If \code{left} is \code{FALSE},
close first break at left?)}

\item{raw}{Logical. Use raw values in labels?}
}
\value{
\verb{chop_*} functions return a \code{\link{factor}} of the same length as \code{x}.

\verb{brk_*} functions return a \code{\link{function}} to create \code{breaks}.

\verb{tab_*} functions return a contingency \code{\link[=table]{table()}}.
}
\description{
\code{chop_equally()} chops \code{x} into groups with an equal number of elements.
}
\details{
\code{chop_equally()} uses \code{\link[=brk_quantiles]{brk_quantiles()}} under the hood. If \code{x} has duplicate
elements, you may get fewer \code{groups} than requested. If so, a warning will
be emitted. See the examples.
}
\examples{
chop_equally(1:10, 5)

# You can't always guarantee `groups` groups:
dupes <- c(1, 1, 1, 2, 3, 4, 4, 4)
quantile(dupes, 0:4/4)
chop_equally(dupes, 4)
}
\seealso{
Other chopping functions: 
\code{\link{chop}()},
\code{\link{chop_evenly}()},
\code{\link{chop_fn}()},
\code{\link{chop_mean_sd}()},
\code{\link{chop_n}()},
\code{\link{chop_proportions}()},
\code{\link{chop_quantiles}()},
\code{\link{chop_width}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
