% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_topics.R
\name{number_topics}
\alias{number_topics}
\title{Number Topics}
\usage{
number_topics(DataFrame, num_cores, min_clusters = 2,
  max_clusters = 12, skip = 2, set_seed = 1234)
}
\arguments{
\item{DataFrame}{DataFrame of Twitter Data.}

\item{num_cores}{The number of CPU cores to processes models simultaneously (2L for dual core processor).}

\item{min_clusters}{Lower range for the number of clusters.}

\item{max_clusters}{Upper range for the number of clusters.}

\item{skip}{Integer; The number of clusters to skip between entries.}

\item{set_seed}{Seed for reproducable results.}
}
\value{
A Tidy DataFrame.
}
\description{
Determines the optimal number of Latent topics within a dataframe by tuning the Latent Dirichlet Allocation (LDA) model parameters.  
Uses the `ldatuning` package and outputs an ldatuning plot.  __This process can be time consuming depending on the size of the input dataframe.__
}
\examples{
\donttest{
library(saotd)
data <- raw_tweets
LDA_Topic_Plot <- number_topics(DataFrame = data,
                                num_cores = 2L,
                                min_clusters = 2,
                                max_clusters = 12, 
                                skip = 2,
                                set_seed = 1234)

LDA_Topic_Plot 
}
}
