% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.R
\name{sfn_plot}
\alias{sfn_plot}
\title{plot method for sfn_data class}
\usage{
sfn_plot(sfn_data, type = c("sapf", "env", "ta", "rh", "vpd", "ppfd_in",
  "netrad", "sw_in", "ext_rad", "ws", "precip", "swc_shallow", "swc_deep"),
  formula_env = NULL, solar = TRUE, ...)
}
\arguments{
\item{sfn_data}{sfn_data object to plot. It can be also an sfn_data_multi
object.}

\item{type}{Character indicating which data to plot. See Type section for
detailed information about the available values. Ignored if formula is
provided}

\item{formula_env}{Right side formula indicating an environmental variable to
plot vs. the sapflow values. If NULL (default), \code{sfn_plot} will use
"type" to guess which plot show.}

\item{solar}{Logical indicating if the solar timestamp must be used instead
of the site timestamp}

\item{...}{Further arguments to be passed on \code{\link{geom_point}} or
\code{\link{geom_col}} to modify geometry aesthetics.}
}
\value{
A ggplot object that can be called to see the plot. If input is an
  sfn_data_multi object, a list with the plots
}
\description{
Plot the desired data from a site object
}
\section{ggplot plotting system}{

  \code{\link{plot}} is a base R function which uses the base R plotting system
  to show the plot. We prefer the ggplot plotting system, which allow for
  storing the plots in objects and can be subjected to further modifications.
  This allow the package users to generate rather simple plots that can be
  fine tuned afterwards to the user taste. Generating a \code{\link{plot}}
  method for the \code{sfn_data} class returning a ggplot object is not
  desired (it change the way plot works and can be misleading about the plot
  general usage). So, instead, we offer this function, \code{sfn_plot}.
}

\section{Type}{

  \code{type} argument controls what is going to be plotted. It accepts
  the following:
  \itemize{
    \item{"sapf": It will plot sapflow data vs. TIMESTAMP}
    \item{"env": It will plot environmental variables vs. TIMESTMAP}
    \item{"ta", "rh", "vpd", "ppfd_in", "netrad", "sw_in", "ext_rad",
          "ws", "precip", "swc_shallow" and "swc_deep": They will plot
          the corresponding variable vs. TIMESTAMP}
  }
}

\section{Formula}{

  \code{formula} argument can be used to select an environmental variable to
  plot versus all the sapflow measurements. Any envirinmental variable is
  allowed, if it exist in the site provided.
}

\section{Geometry}{

  By default \code{sfn_plot} generates plots using \code{\link{geom_point}}
  geometry, except in the case of \code{type = "ws"} and
  \code{type = "precip"} where \code{\link{geom_col}} is used. These
  geometries can be modified with the \code{...} argument.
}

\examples{
library(ggplot2)

# data
data('ARG_TRE', package = 'sapfluxnetr')

# plotting directly
sfn_plot(ARG_TRE, type = 'sapf')

# this could be noisy, you can facet by "Tree" (for sapflow) or by
# "Variable" (for environmental data):
sfn_plot(ARG_TRE, type = 'sapf') +
  facet_wrap(~ Tree)

sfn_plot(ARG_TRE, type = 'env') +
  facet_wrap(~ Variable, scales = 'free_y')

# saving and modifying:
env_plot <- sfn_plot(ARG_TRE, type = 'env', solar = FALSE) +
  facet_wrap(~ Variable, scales = 'free_y')
env_plot + labs(title = 'Environmental variables facet plot')

# formula
sfn_plot(ARG_TRE, formula_env = ~ vpd)

}
