% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_sass.R
\name{as_sass}
\alias{as_sass}
\title{List to Sass converter}
\usage{
as_sass(input)
}
\arguments{
\item{input}{Either a
\itemize{
  \item raw Sass string
  \item named list containing variable names and values
  \item Sass-like file name.

}}
}
\value{
a single character value to be supplied to \code{\link{sass}}
}
\description{
Converts multiple types of inputs to a single Sass input string for
\code{\link{sass}}.
}
\details{
Note that the LibSass compiler expects .sass files to use the Sass Indented
Syntax.
}
\examples{
# Example of regular Sass input
as_sass("body { color: \"blue\"; }")

# There is support for adding variables
as_sass(
  list(
    list(color = "blue"),
   "body { color: $color; }"
   )
)

\donttest{
# Add a file name
someFile <- tempfile("variables")

# Overwrite color to red
write("$color: \"red\";", someFile)

input <-
  as_sass(
    list(
      list(color = "blue"),
      sass_file(someFile),
      "body { color: $color; }"
      )
   )

input

# The final body color is red
sass(input)
}
}
\seealso{
Visit
  \url{https://sass-lang.com/documentation/file.SASS_REFERENCE.html#import}
  for more details.
}
