% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_sim.r
\name{sbpiper_sim}
\alias{sbpiper_sim}
\title{Main R function for SBpipe pipeline: simulate().}
\usage{
sbpiper_sim(model, inputdir, outputdir, outputfile_stats, outputfile_repeats,
  exp_dataset, plot_exp_dataset, exp_dataset_alpha, xaxis_label, yaxis_label,
  column_to_read)
}
\arguments{
\item{model}{the model name}

\item{inputdir}{the input directory}

\item{outputdir}{the output directory}

\item{outputfile_stats}{the output file containing the statistics}

\item{outputfile_repeats}{the output file storing the model simulation repeats}

\item{exp_dataset}{the file containing the experimental data.}

\item{plot_exp_dataset}{TRUE if the experimental data should also be plotted}

\item{exp_dataset_alpha}{the alpha level for the data set}

\item{xaxis_label}{the label for the x axis (e.g. Time (min))}

\item{yaxis_label}{the label for the y axis (e.g. Level (a.u.))}

\item{column_to_read}{the name of the column to process}
}
\description{
Main R function for SBpipe pipeline: simulate().
}
\examples{
\donttest{
data(insulin_receptor_1)
data(insulin_receptor_2)
data(insulin_receptor_3)
data(insulin_receptor_exp_dataset)
dir.create(file.path("sim_datasets"))
dir.create(file.path("sim_datasets_sum"))
write.table(insulin_receptor_1, 
            file=file.path("sim_datasets", "insulin_receptor_1.csv"), 
            row.names=FALSE)
write.table(insulin_receptor_2, 
            file=file.path("sim_datasets", "insulin_receptor_2.csv"), 
            row.names=FALSE)
write.table(insulin_receptor_3, 
            file=file.path("sim_datasets", "insulin_receptor_3.csv"), 
            row.names=FALSE)
write.table(insulin_receptor_exp_dataset, 
            file="insulin_receptor_exp_dataset.csv", 
            row.names=FALSE)
sbpiper_sim(model="insulin_receptor", 
           inputdir="sim_datasets", 
           outputdir="sim_plots", 
           outputfile_stats="insulin_receptor_IR_beta_pY1146_stats.csv", 
           outputfile_repeats=file.path("sim_datasets_sum", 
                                        "insulin_receptor_IR_beta_pY1146.csv"), 
           exp_dataset="insulin_receptor_exp_dataset.csv", 
           plot_exp_dataset=TRUE, 
           exp_dataset_alpha=1.0, 
           xaxis_label=NULL, 
           yaxis_label=NULL, 
           column_to_read="IR_beta_pY1146")
}
}
