% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_get_parent.R
\name{item_get_parent}
\alias{item_get_parent}
\title{Get an item's parent ID}
\usage{
item_get_parent(sb_id, ..., session = current_session())
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\value{
An item object representing the parent of the supplied item.
}
\description{
Retrieves the parent of a supplied item based on the ScienceBase
item tree hierarchy.
}
\examples{
\donttest{
item_get_parent("4f4e4b24e4b07f02db6aea14")

item_get("4f4e4b24e4b07f02db6aea14") \%>\% item_get_parent()
}
}
