% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_update_identifier.R
\name{item_update_identifier}
\alias{item_update_identifier}
\title{Add custom identifier to an existing item}
\usage{
item_update_identifier(sb_id, scheme, type, key, ...)
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{scheme}{The identifier scheme}

\item{type}{The identifier type}

\item{key}{The identifier key}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}.}
}
\description{
Adds or updates an item's alternative identifier. This can add 
additional identifiers or update those already in place. See
\code{\link{query_item_identifier}} for finding items based on alternative
identifier.
}
\examples{
\dontrun{

initialize_sciencebase_session()
item_update_identifier("5485fd99e4b02acb4f0c7e81", "scheme", "type", "key")

}

}
