% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class.R
\name{findmarkergene}
\alias{findmarkergene}
\title{Find potential marker genes for each cluster}
\usage{
findmarkergene(
  object,
  species = NULL,
  cluster = "All",
  if_use_custom_marker = FALSE,
  marker = NULL,
  cancer = "Normal",
  tissue = NULL,
  use_method = "1",
  comp_cluster = NULL,
  cell_min_pct = 0.25,
  logfc = 0.25,
  pvalue = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{object}{scCATCH object generated from \code{\link{createscCATCH}}.}

\item{species}{The specie of cells. The species must be defined. 'Human' or 'Mouse'. When if_use_custom_marker is set TRUE, no need to define the species.}

\item{cluster}{Select which clusters for potential marker genes identification. e.g. '1', '2', etc. The default is 'All' to find potential makrer genes for each cluster.}

\item{if_use_custom_marker}{Whether to use custom markers data.frame.}

\item{marker}{A data.frame containing marker genes. See \code{\link{demo_marker}}. Default is to use the system \code{\link{cellmatch}} data.frame.}

\item{cancer}{If the sample is from cancer tissue, then the cancer type may be defined. When if_use_custom_marker is set TRUE, no need to define the species.}

\item{tissue}{Tissue origin of cells must be defined. Select one or more related tissue types. When if_use_custom_marker is set TRUE, no need to define the species.}

\item{use_method}{'1' is to compare with other every cluster. '2' is to compare with other clusters together.}

\item{comp_cluster}{Number of clusters to compare. Default is to compare all other cluster for each cluster. Set it between 1 and length of unique clusters. More marker genes will be obtained for smaller comp_cluster.}

\item{cell_min_pct}{Include the gene detected in at least this many cells in each cluster.}

\item{logfc}{Include the gene with at least this fold change of average gene expression compared to every other clusters.}

\item{pvalue}{Include the significantly highly expressed gene with this cutoff of p value from wilcox test compared to every other clusters.}

\item{verbose}{Show progress messages.}
}
\value{
scCATCH object
}
\description{
Identify potential marker genes for each cluster.
}
\details{
Details of available tissues see \url{https://github.com/ZJUFanLab/scCATCH/wiki}
}
