% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function.R
\name{cellTypeGOCorr}
\alias{cellTypeGOCorr}
\title{calculate correlation between cell types represented by scaled GO, per-species}
\usage{
cellTypeGOCorr(cell_type_go, corr_method = "pearson")
}
\arguments{
\item{cell_type_go}{cell type GO table calculated via getCellTypeGO}

\item{corr_method}{correlation method, choose among "pearson", "kendall", "spearman", default 'pearson'}
}
\value{
a dataframe with correlation between cell types
}
\description{
calculate correlation between cell types represented by scaled GO, per-species
}
\examples{
\donttest{
library(scGOclust)
library(httr)
httr::set_config(httr::config(ssl_verifypeer = FALSE))
data(mmu_tbl)
data(mmu_subset)
go_seurat_obj = makeGOSeurat(ensembl_to_GO = mmu_tbl,
 seurat_obj = mmu_subset,
 feature_type = "external_gene_name")

cell_type_go = getCellTypeGO(go_seurat_obj = go_seurat_obj, cell_type_co = "cell_type_annotation")

cellTypeGOCorr(cell_type_go = cell_type_go, corr_method = "pearson")
}

}
