% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/determine_ranks_tucker.R
\name{determine_ranks_tucker}
\alias{determine_ranks_tucker}
\title{Run rank determination by svd on the tensor unfolded along each mode}
\usage{
determine_ranks_tucker(
  container,
  max_ranks_test,
  shuffle_level = "cells",
  shuffle_within = NULL,
  num_iter = 100,
  batch_var = NULL,
  norm_method = "trim",
  scale_factor = 10000,
  scale_var = TRUE,
  var_scale_power = 0.5,
  seed = container$experiment_params$rand_seed
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{max_ranks_test}{numeric Vector of length 2 specifying the maximum number of
donor and gene ranks to test}

\item{shuffle_level}{character Either "cells" to shuffle cell-donor linkages or
"tensor" to shuffle values within the tensor (default="cells")}

\item{shuffle_within}{character A metadata variable to shuffle cell-donor linkages
within (default=NULL)}

\item{num_iter}{numeric Number of null iterations (default=100)}

\item{batch_var}{character A batch variable from metadata to remove. No batch
correction applied if NULL. (default=NULL)}

\item{norm_method}{character The normalization method to use on the pseudobulked
count data. Set to 'regular' to do standard normalization of dividing by
library size. Set to 'trim' to use edgeR trim-mean normalization, whereby counts
are divided by library size times a normalization factor. (default='trim')}

\item{scale_factor}{numeric The number that gets multiplied by fractional counts
during normalization of the pseudobulked data (default=10000)}

\item{scale_var}{logical TRUE to scale the gene expression variance across donors
for each cell type. If FALSE then all genes are scaled to unit variance across
donors for each cell type. (default=TRUE)}

\item{var_scale_power}{numeric Exponent of normalized variance that is
used for variance scaling. Variance for each gene
is initially set to unit variance across donors (for a given cell type).
Variance for each gene is then scaled by multiplying the unit scaled values
by each gene's normalized variance (where the effect of the mean-variance
dependence is taken into account) to the exponent specified here.
If NULL, uses var_scale_power from container$experiment_params. (default=.5)}

\item{seed}{numeric Seed passed to set.seed() (default=container$experiment_params$rand_seed)}
}
\value{
The project container with a cowplot figure of rank determination plots in
container$plots$rank_determination_plot.
}
\description{
Run rank determination by svd on the tensor unfolded along each mode
}
\examples{
test_container <- determine_ranks_tucker(test_container, max_ranks_test=c(3,5),
shuffle_level='tensor', num_iter=4, norm_method='trim', scale_factor=10000,
scale_var=TRUE, var_scale_power=.5)
}
