% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tucker.R
\name{render_multi_plots}
\alias{render_multi_plots}
\title{Create a figure of all loadings plots arranged}
\usage{
render_multi_plots(container, data_type, max_cols = 3)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{data_type}{character Can be either "loadings", "gsea", or "dgenes". This
determines which list of heatmaps to organize into the figure.}

\item{max_cols}{numeric The max number of columns to plot. Can only either be 2
or 3 since these are large plots. (default=3)}
}
\value{
The multi-plot figure.
}
\description{
Create a figure of all loadings plots arranged
}
\examples{
test_container <- get_all_lds_factor_plots(test_container)
fig <- render_multi_plots(test_container, data_type='loadings')
}
