% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_LR_interact.R
\name{get_module_enr}
\alias{get_module_enr}
\title{Identify gene sets that are enriched within specified gene co-regulatory modules.
Uses a hypergeometric test for over-representation. Used in plot_multi_module_enr().}
\usage{
get_module_enr(container, ctype, mod_select, db_use = "GO", adjust_pval = TRUE)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{ctype}{character The name of cell type for the cell type module to test}

\item{mod_select}{numeric The module number for the cell type module to test}

\item{db_use}{character The database of gene sets to use. Database
options include "GO", "Reactome", "KEGG", "BioCarta", "Hallmark", "TF", and
"immuno". More than one database can be used. (default="GO")}

\item{adjust_pval}{logical Set to TRUE to apply FDR correction (default=TRUE)}
}
\value{
A vector of p-values for the tested gene sets.
}
\description{
Identify gene sets that are enriched within specified gene co-regulatory modules.
Uses a hypergeometric test for over-representation. Used in plot_multi_module_enr().
}
