% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manage_scMinimal.R
\name{instantiate_scMinimal}
\alias{instantiate_scMinimal}
\title{Create an scMinimal object. Generally, this should be done through calling the
make_new_container() wrapper function.}
\usage{
instantiate_scMinimal(
  count_data,
  meta_data,
  metadata_cols = NULL,
  metadata_col_nm = NULL
)
}
\arguments{
\item{count_data}{sparseMatrix Matrix of raw counts with genes as rows
and cells as columns}

\item{meta_data}{data.frame Metadata with cells as rows and variables
as columns. Number of rows in metadata should equal number of columns
in count matrix.}

\item{metadata_cols}{character The names of the metadata columns to use
(default=NULL)}

\item{metadata_col_nm}{character New names for the selected metadata columns
if wish to change their names. If NULL, then the preexisting column names are
used. (default=NULL)}
}
\value{
An scMinimal object holding counts and metadata for a project.
}
\description{
Create an scMinimal object. Generally, this should be done through calling the
make_new_container() wrapper function.
}
\examples{
scMinimal <- instantiate_scMinimal(count_data=test_container$scMinimal_full$count_data,
meta_data=test_container$scMinimal_full$metadata)
}
