% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellmarker_enrich.R
\name{cellmarker_enrich}
\alias{cellmarker_enrich}
\title{Fisher's Exact Cell-Type Identification.}
\usage{
cellmarker_enrich(
  gene_list,
  p_thresh,
  gmt = "cellmarker_list.Rdata",
  fixed_length = 13000,
  min_genes = 5,
  max_genes = 3000,
  isect_size = 3
)
}
\arguments{
\item{gene_list}{A character vector of gene symbols with the same designation (e.g. mouse symbol - mouse, human symbol - human) as the gene set database.}

\item{p_thresh}{The Fisher's test cutoff for a cell-marker to be enriched.}

\item{gmt}{Either a path to an rda file containing an object called "gmt", which is a named list where each element of the list is a vector of gene symbols website for more detail on the file type (https://software.broadinstitute.org/cancer/software/gsea/wiki/index.php/Data_formats). The gmt list may also be inputted.}

\item{fixed_length}{Estimated number of genes in your background.}

\item{min_genes}{Minimum number of genes in the cell-type markers.}

\item{max_genes}{Maximum number of genes in the cell-type markers.}

\item{isect_size}{Number of genes in your list and the cell-type.}
}
\value{
\code{cellmarker_enrich} Gene set enrichment of cell-types on your inputted gene list. \cr
}
\description{
This function uses the CellMarker and Panglao datasets to identify cell-type differentially expressed genes.
}
\details{
Complete a Fisher's exact test of an input list of genes against a gene set saved in an *.RData object.
The RData object is storing a named list of genes called "gmt".
}
\examples{


data(POA_example)
POA_generes <- POA_example$POA_generes
POA_OR_signature <- POA_example$POA_OR_signature
POA_Rank_signature <- POA_example$POA_Rank_signature
Signature <- POA_Rank_signature
rowname <- get_gene_symbol(Signature)
rownames(Signature) <- rowname$rowname
genes <- rownames(Signature)[1:100]
data(gmt)
enriched <- cellmarker_enrich(gene_list = genes, 
                              p_thresh = 0.05, gmt = gmt)

 
}
