% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SCALPEL_reviewNeurons.R
\name{getNeuronStatus}
\alias{getNeuronStatus}
\title{Read in the manual classifications of neurons from SCALPEL.}
\usage{
getNeuronStatus(scalpelOutput, neuronSet)
}
\arguments{
\item{scalpelOutput}{An object returned by one of the SCALPEL functions:
\code{\link{scalpel}}, \code{\link{scalpelStep2}}, or \code{\link{scalpelStep3}}.}

\item{neuronSet}{The set of neurons that should be reviewed:
use \code{"A"} for those resulting from \code{\link{scalpelStep2}} and saved as \code{scalpelOutput$A}, or use \code{"Afilter"} for those resulting from
\code{\link{scalpelStep3}} and saved as \code{scalpelOutput$Afilter}. This argument is ignored if the class of \code{scalpelOutput} is \code{scalpelStep2}.}
}
\value{
A vector of length equal to the number of columns in \code{scalpelOutput$A} if \code{neuronSet="A"} or \code{scalpelOutput$Afilter} if \code{neuronSet="Afilter"}.
The elements give the manual classifications of the neurons. The possible classifications are: \code{"yes"} if
a neuron is to be kept, \code{"no"} if a neuron is to be discarded, \code{"unsure"} if a neuron needs to be reviewed further, and
\code{NA} if a neuron has not yet been classified.
}
\description{
This function allows the user to read in the manual classifications of neurons, based on the classifying done using
\code{\link{reviewNeurons}} or \code{\link{reviewNeuronsInteractive}}.
}
\examples{
\dontrun{
### many of the functions in this package are interconnected so the
### easiest way to learn to use the package is by working through the vignette,
### which is available at ajpete.com/software

#assumes you have run the example for the "updateNeurons" function

getNeuronStatus(scalpelOutput = scalpelOutput, neuronSet = "Afilter")
}
}
\seealso{
\code{\link{reviewNeurons}}, \code{\link{reviewNeuronsInteractive}}
}

