% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zone_utility_functions.R
\name{join_zones}
\alias{join_zones}
\title{Creates a new \code{data.table} from a table containing locations,
adding a column for zone.}
\usage{
join_zones(locations_etc, zones, keys = c("zone"))
}
\arguments{
\item{locations_etc}{A \code{data.table} with column \code{location}
and other columns (but none for \code{zone}).}

\item{zones}{A list of zones, elements being vectors of locations.}

\item{keys}{Character vector of one or more column names; these columns
are set as key columns in the output \code{data.table}.}
}
\value{
A new \code{data.table} with a column for \code{zone} added
   to the supplied table of locations etc. (not modified).
}
\description{
Takes a \code{data.table} with containing column \code{location} and 
possibly other columns, and creates a new \code{data.table} with 
a column for zone added to the columns in the supplied table, 
according to the zones in the supplied list of zones.
The key colums of the resulting \code{data.table} can be specified.
}
\examples{
\dontrun{
locs_etc <- table_creator(list(location = 1:2, duration = 1:3, stream = 1:2))
join_zones(locs_etc, list(1, 2, 1:2), keys = c("duration", "zone"))
}
}
\keyword{internal}

