% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scan_zip.R
\name{zip_calculations}
\alias{zip_calculations}
\title{Calculate the (logarithm of the) ZIP statistic for each space-time window.}
\usage{
zip_calculations(table, zones, ...)
}
\arguments{
\item{table}{A \code{data.table} with columns \code{location, duration, mu,
p, count}. The column \code{mu} contains the Poisson expected value 
parameters, the column \code{p} contains the excess zero probabilities.}

\item{zones}{A \code{set} of zones, each zone itself being a \code{set}
containing locations. Locations should be encoded as integers.}

\item{...}{Arguments passed to \code{\link{simulate_zip_scanstatistic}}.}
}
\value{
A \code{data.table} with columns \code{zone, duration, statistic}.
}
\description{
Calculate the logarithm of the ZIP statistic for each space-time window, 
summing over the locations and times in the window.
}
\keyword{internal}

