% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scatter_lines_rgbwt.R
\name{scatter_lines_rgbwt}
\alias{scatter_lines_rgbwt}
\title{scatter_lines_rgbwt}
\usage{
scatter_lines_rgbwt(
  xy,
  xlim = c(min(xy[, c(1, 3)]), max(xy[, c(1, 3)])),
  ylim = c(min(xy[, c(2, 4)]), max(xy[, c(2, 4)])),
  out_size = c(512, 512),
  RGBA = c(0, 0, 0, 255),
  skip_start_pixel = FALSE,
  skip_end_pixel = TRUE
)
}
\arguments{
\item{xy}{4-column matrix with point coordinates. Format is
\verb{(x_begin, y_begin, x_end, y_end)}. As usual with
rasters in R, X axis grows right, and Y axis grows DOWN.
Flipping \code{ylim} causes the "usual" mathematical behavior.}

\item{xlim}{Limits as usual (position of the first pixel on the
left/top, and the last pixel on the right/bottom), 2-element vector.
You can easily flip the top/bottom to the "usual" mathematical
system by flipping the \code{ylim} vector.}

\item{ylim}{Limits as usual (position of the first pixel on the
left/top, and the last pixel on the right/bottom), 2-element vector.
You can easily flip the top/bottom to the "usual" mathematical
system by flipping the \code{ylim} vector.}

\item{out_size}{2-element vector size of the result raster,
defaults to \code{c(512,512)}.}

\item{RGBA}{Vector with 4 elements with R, G, B and alpha channels in integers,
defaults to \code{c(0,0,0,255)}.}

\item{skip_start_pixel}{TRUE if the start pixel of a line should not be plotted,
otherwise 'FALSE', defaults to \code{FALSE}.}

\item{skip_end_pixel}{TRUE if the end pixel of a line should not be plotted,
otherwise 'FALSE', defaults to \code{TRUE}.}
}
\value{
An array in RGBWT format with the scatterplot output.
}
\description{
Draw lines with given start and end points.
}
