% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{smooth_count_matrix}
\alias{smooth_count_matrix}
\title{Smooth gene expression, used primarily within conos::correctGenes. Used to smooth gene expression values in order to better represent the graph structure.
Use diffusion of expression on graph with the equation dv = exp(-a * (v + b))}
\usage{
smooth_count_matrix(
  edge_verts,
  edge_weights,
  count_matrix,
  is_label_fixed,
  max_n_iters = 10L,
  diffusion_fading = 1,
  diffusion_fading_const = 0.1,
  tol = 0.001,
  verbose = TRUE,
  normalize = FALSE
)
}
\arguments{
\item{edge_verts}{edge vertices of igraph graph object}

\item{edge_weights}{edge weights of igraph graph object}

\item{count_matrix}{gene count matrix}

\item{is_label_fixed}{boolean Whether label is fixed}

\item{max_n_iters}{integer Maximal number of iterations (default=10)}

\item{diffusion_fading}{numeric Constant used for diffusion on the graph, exp(-diffusion.fading * (edge_length + diffusion.fading.const)) (default=1.0)}

\item{diffusion_fading_const}{numeric Another constant used for diffusion on the graph, exp(-diffusion.fading * (edge_length + diffusion.fading.const)) (default=0.1)}

\item{tol}{numeric Absolute tolerance as a stopping criteria (default=1e-3)}

\item{verbose}{boolean Verbose mode (default=TRUE)}

\item{normalize}{boolean Whether to normalize values (default=FALSE)}
}
\value{
matrix from input graph, with labels propagated
}
\description{
Smooth gene expression, used primarily within conos::correctGenes. Used to smooth gene expression values in order to better represent the graph structure.
Use diffusion of expression on graph with the equation dv = exp(-a * (v + b))
}
