% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randomization_test.R
\name{randomization_test}
\alias{randomization_test}
\title{Randomization Test for Single-Case Experiments}
\usage{
randomization_test(
  .df,
  .out,
  .cond,
  .time,
  num_permutations = NULL,
  consec = c("observed", "fixed"),
  max_consec = NULL,
  min_consec = NULL,
  cond_levels = NULL,
  cond_labels = NULL,
  conf.level = 0.95,
  .bins = 30
)
}
\arguments{
\item{.df}{A data frame containing the variables of interest.}

\item{.out}{The name of the outcome variable in \code{.df}.}

\item{.cond}{The name of the condition variable in \code{.df}. This variable should
have two levels.}

\item{.time}{The name of the time variable in \code{.df}.}

\item{num_permutations}{The number of permutations to perform. If \code{NULL}, all
possible permutations are considered.}

\item{consec}{Specifies the constraint on consecutive sequences for permutation.
Can be \code{"observed"} for the observed sequence length or \code{"fixed"} for
a specified sequence length. Defaults to \code{"observed"}.}

\item{max_consec}{The maximum number of consecutive observations of the same
condition to allow in permutations. If \code{NULL}, no maximum is enforced.
To implement \code{max_consec}, \code{consec} must be set to \code{"fixed"}.}

\item{min_consec}{The minimum number of consecutive observations of the same
condition to allow in permutations. If \code{NULL}, no minimum is enforced.
To implement \code{min_consec}, \code{consec} must be set to \code{"fixed"}.}

\item{cond_levels}{Explicitly sets the levels of the condition variable. If
\code{NULL}, the levels are derived from the data.}

\item{cond_labels}{Labels for the condition levels. If \code{NULL}, levels are used
as labels.}

\item{conf.level}{The confidence level for the confidence interval calculation.
Defaults to 0.95.}

\item{.bins}{The number of bins to use for the histogram of the test statistic
distribution. Defaults to 30.}
}
\value{
A list containing the original difference in means, the p-value of the
test, the distribution of test statistics under the null hypothesis,
confidence intervals, and plots of the distribution of mean differences
and the raw data.
}
\description{
Performs a randomization test on data from single-case experiments. This
function allows for the assessment of treatment effects by comparing the observed
outcome difference to a distribution of differences obtained through permutation.
It supports various constraints on permutation sequences, such as fixed or
observed maximum and minimum consecutive sequences of a particular condition.
The function also provides graphical summaries of the raw data and the
distribution of mean differences.
}
\examples{
result <- randomization_test(sleeping_pills, .out = "sever_compl",
                             .cond = "treatment", .time = "day",
                             num_permutations = 100,
                             cond_levels = c("C", "E"))

result$conf_int

}
\references{
Onghena, P. (2020). One by One: The design and analysis of replicated randomized
single-case experiments.In R. van de Schoot & M. Mioecvic (Eds.), Small Sample
Size Solutions: A Guide for Applied Researchers and Practitioners (1st ed., pp.
15). Routledge. \url{doi:10.4324/9780429273872-8}
}
