% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_plot_hex.R
\name{scf_plot_hex}
\alias{scf_plot_hex}
\title{Hexbin Plot of Two Continuous SCF Variables}
\usage{
scf_plot_hex(design, x, y, bins = 50, title = NULL, xlab = NULL, ylab = NULL)
}
\arguments{
\item{design}{A \code{scf_mi_survey} object created by \code{\link[=scf_load]{scf_load()}}.}

\item{x}{A one-sided formula for the x-axis variable (e.g., \code{~income}).}

\item{y}{A one-sided formula for the y-axis variable (e.g., \code{~networth}).}

\item{bins}{Integer. Number of hexagonal bins along the x-axis. Default is \code{50}.}

\item{title}{Optional character string for the plot title.}

\item{xlab}{Optional x-axis label. Defaults to the variable name.}

\item{ylab}{Optional y-axis label. Defaults to the variable name.}
}
\value{
A \code{ggplot2} object displaying a Rubin-pooled hexbin plot.
}
\description{
Visualizes the bivariate relationship between two continuous SCF variables
using hexagonal bins.
}
\section{Implementation}{

The function stacks all implicates into one data frame, retains replicate weights,
and uses \code{ggplot2::geom_hex()} to produce a density-style scatterplot. The color
intensity of each hexagon reflects the Rubin-pooled weighted count of households
in that cell. Missing values are excluded.

This plot is especially useful for visualizing joint distributions with large
samples and skewed marginals, such as net worth vs. income.
}

\section{Aesthetic Guidance}{

This plot uses a log-scale fill and \code{viridis} palette to highlight variation
in density. To adjust the visual style globally, use \code{\link[=scf_theme]{scf_theme()}} or set it
explicitly with \code{ggplot2::theme_set(scf_theme())}. For mobile-friendly or
publication-ready appearance, export the plot at 5.5 x 5.5 inches, 300 dpi.
}

\section{Dependencies}{

Requires the \code{ggplot2} package. The fill scale uses \code{scale_fill_viridis_c()} from \code{ggplot2}.
Requires the \pkg{hexbin} package. The function will stop with an error if it is not installed.
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: Plot hexbin of income vs. net worth
scf_plot_hex(scf2022, ~income, ~networth)

# Do not implement these lines in real analysis: Cleanup for package check
unlink("scf2022.rds", force = TRUE)

}
\seealso{
\code{\link[=scf_corr]{scf_corr()}}, \code{\link[=scf_plot_smooth]{scf_plot_smooth()}}, \code{\link[=scf_theme]{scf_theme()}}
}
