% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_subset.R
\name{scf_subset}
\alias{scf_subset}
\title{Subset an \code{scf_mi_survey} Object}
\usage{
scf_subset(scf, expr)
}
\arguments{
\item{scf}{A \code{scf_mi_survey} object, typically created by \code{\link[=scf_load]{scf_load()}}.}

\item{expr}{A logical expression used to filter rows, evaluated separately in each implicate's variable frame (e.g., \code{age < 65 & own == 1}).}
}
\value{
A new \code{scf_mi_survey} object (see \code{\link[=scf_design]{scf_design()}})
}
\description{
Subsetting refers to the process of retaining only those observations that
satisfy a logical (TRUE/FALSE) condition. This function applies such a
filter independently to each implicate in an \code{scf_mi_survey} object created
by \code{\link[=scf_design]{scf_design()}} via \code{\link[=scf_load]{scf_load()}}. The result is a new multiply-imputed,
replicate-weighted survey object with appropriately restricted designs.
}
\section{Implementation}{

Use \code{scf_subset()} to focus analysis on analytically meaningful
sub-populations. For example, to analyze only households headed by seniors:

``r
scf2022_seniors <- scf_subset(scf2022, age >= 65)

\if{html}{\out{<div class="sourceCode">}}\preformatted{
This is especially useful when analyzing populations such as renters, homeowners, specific age brackets,
or any group defined by logical expressions over SCF variables.
}\if{html}{\out{</div>}}
}

\section{Details}{

Filtering is conducted separately in each implicate. This preserves valid design structure but means
that the same household may fall into or out of the subset depending on imputed values.
For example, a household with five different age imputations—say, 64, 66, 63, 65, and 67—would be
classified as a senior in only three of five implicates if subsetting on \code{age >= 65}.

Empty subsets in any implicate can cause downstream analysis to fail. Always check subgroup sizes after subsetting.
}

\examples{
# Mock workflow for CRAN (demo only — not real SCF data)
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Filter for working-age households with positive net worth
scf_sub <- scf_subset(scf2022, age < 65 & networth > 0)
scf_mean(scf_sub, ~income)

# Do not implement these lines in real analysis: Cleanup for package check
unlink("scf2022.rds", force = TRUE)


}
\seealso{
\code{\link[=scf_load]{scf_load()}}, \code{\link[=scf_update]{scf_update()}}
}
