% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Request.R
\name{Request}
\alias{Request}
\title{Class Request.}
\description{
Class Request.

Class Request.
}
\details{
This class represents a Request object that can be used with the Request
Scheduler.
}
\examples{
# Create a GET request for the getCompleteEntity webservice of ChEBI database
request <- sched::Request$new(
  sched::URL$new(
    'https://www.ebi.ac.uk/webservices/chebi/2.0/test/getCompleteEntity',
    params=c(chebiId=15440)))

# Get an MD5 key, unique to this request
key <- request$getUniqueKey()

# Print the request
print(request)


## ------------------------------------------------
## Method `Request$new`
## ------------------------------------------------

# Create a GET request for the getCompleteEntity webservice of ChEBI
# database
request <- sched::Request$new(
  sched::URL$new(
    'https://www.ebi.ac.uk/webservices/chebi/2.0/test/getCompleteEntity',
    params=c(chebiId=15440)))

# Create a POST Request object for the records-batch-post webservice of
# ChemSpider database
request <- sched::Request$new(
  url=sched::URL$new(c('https://api.rsc.org/compounds/v1/', 'records',
                       'batch')),
  method='post', header=c('Content-Type'="", apikey='my-token'),
  body='{"recordIds": [2], "fields": ["SMILES","Formula","InChI"]}')


## ------------------------------------------------
## Method `Request$getUrl`
## ------------------------------------------------

# Create a GET request
request <- sched::Request$new(sched::URL$new('https://peakforest.org/'))

# Get the stored URL object
print(request$getUrl())

## ------------------------------------------------
## Method `Request$getMethod`
## ------------------------------------------------

# Create a GET request
request <- sched::Request$new(sched::URL$new('https://peakforest.org/'))

# Get the stored method
print(request$getMethod())

## ------------------------------------------------
## Method `Request$getEncoding`
## ------------------------------------------------

# Create a GET request
request <- sched::Request$new(sched::URL$new('https://my.site.fr/'),
                              encoding='UTF-8')

# Get the stored encoding
print(request$getEncoding())

## ------------------------------------------------
## Method `Request$getCurlOptions`
## ------------------------------------------------

# Create a POST Request object for the records-batch-post webservice of
# ChemSpider database
request <- sched::Request$new(
  url=sched::URL$new(c('https://api.rsc.org/compounds/v1/', 'records',
                       'batch')),
  method='post', header=c('Content-Type'="", apikey='my-token'),
  body='{"recordIds": [2], "fields": ["SMILES","Formula","InChI"]}')

# Get the associated RCurl options object
rcurl_opts <- request$getCurlOptions('myapp ; me@my.address')


## ------------------------------------------------
## Method `Request$getUniqueKey`
## ------------------------------------------------

# Create a GET request
request <- sched::Request$new(sched::URL$new('https://peakforest.org/'))

# Get the MD5 sum of this request
print(request$getUniqueKey())


## ------------------------------------------------
## Method `Request$getHeaderAsSingleString`
## ------------------------------------------------

# Create a POST Request object for the records-batch-post webservice of
# ChemSpider database
request <- sched::Request$new(
  url=sched::URL$new(c('https://api.rsc.org/compounds/v1/', 'records',
                       'batch')),
  method='post', header=c('Content-Type'="", apikey='my-token'),
  body='{"recordIds": [2], "fields": ["SMILES","Formula","InChI"]}')

# Get back the POST header as a single string
print(request$getHeaderAsSingleString())


## ------------------------------------------------
## Method `Request$getBody`
## ------------------------------------------------

# Create a POST Request object for the records-batch-post webservice of
# ChemSpider database
request <- sched::Request$new(
  url=sched::URL$new(c('https://api.rsc.org/compounds/v1/', 'records',
                       'batch')),
  method='post', header=c('Content-Type'="", apikey='my-token'),
  body='{"recordIds": [2], "fields": ["SMILES","Formula","InChI"]}')

# Get back the POST body
print(request$getBody())


## ------------------------------------------------
## Method `Request$print`
## ------------------------------------------------

# Create a GET request
request <- sched::Request$new(sched::URL$new('https://peakforest.org/'))

# Print the Request object
print(request)


## ------------------------------------------------
## Method `Request$toString`
## ------------------------------------------------

# Create a GET request
request <- sched::Request$new(sched::URL$new('https://peakforest.org/'))

# Get the string representation of this request
print(request$toString())

}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Request-new}{\code{Request$new()}}
\item \href{#method-Request-getUrl}{\code{Request$getUrl()}}
\item \href{#method-Request-getMethod}{\code{Request$getMethod()}}
\item \href{#method-Request-getEncoding}{\code{Request$getEncoding()}}
\item \href{#method-Request-getCurlOptions}{\code{Request$getCurlOptions()}}
\item \href{#method-Request-getUniqueKey}{\code{Request$getUniqueKey()}}
\item \href{#method-Request-getHeaderAsSingleString}{\code{Request$getHeaderAsSingleString()}}
\item \href{#method-Request-getBody}{\code{Request$getBody()}}
\item \href{#method-Request-print}{\code{Request$print()}}
\item \href{#method-Request-toString}{\code{Request$toString()}}
\item \href{#method-Request-clone}{\code{Request$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-new"></a>}}
\if{latex}{\out{\hypertarget{method-Request-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$new(
  url,
  method = c("get", "post"),
  header = NULL,
  body = NULL,
  encoding = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{A \code{sched::URL} object.}

\item{\code{method}}{HTTP method. Either "get" or "post".}

\item{\code{header}}{The header of the POST method as a named character vector.
The names are the fields of the header.}

\item{\code{body}}{The body as a character single value.}

\item{\code{encoding}}{The encoding to use. A valid integer or string as
required by RCurl.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a GET request for the getCompleteEntity webservice of ChEBI
# database
request <- sched::Request$new(
  sched::URL$new(
    'https://www.ebi.ac.uk/webservices/chebi/2.0/test/getCompleteEntity',
    params=c(chebiId=15440)))

# Create a POST Request object for the records-batch-post webservice of
# ChemSpider database
request <- sched::Request$new(
  url=sched::URL$new(c('https://api.rsc.org/compounds/v1/', 'records',
                       'batch')),
  method='post', header=c('Content-Type'="", apikey='my-token'),
  body='{"recordIds": [2], "fields": ["SMILES","Formula","InChI"]}')

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-getUrl"></a>}}
\if{latex}{\out{\hypertarget{method-Request-getUrl}{}}}
\subsection{Method \code{getUrl()}}{
Gets the URL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$getUrl()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The URL of this Request object as a sched::URL object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a GET request
request <- sched::Request$new(sched::URL$new('https://peakforest.org/'))

# Get the stored URL object
print(request$getUrl())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-getMethod"></a>}}
\if{latex}{\out{\hypertarget{method-Request-getMethod}{}}}
\subsection{Method \code{getMethod()}}{
Gets the method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$getMethod()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The method as a character value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a GET request
request <- sched::Request$new(sched::URL$new('https://peakforest.org/'))

# Get the stored method
print(request$getMethod())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-getEncoding"></a>}}
\if{latex}{\out{\hypertarget{method-Request-getEncoding}{}}}
\subsection{Method \code{getEncoding()}}{
Gets the encoding.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$getEncoding()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The encoding.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a GET request
request <- sched::Request$new(sched::URL$new('https://my.site.fr/'),
                              encoding='UTF-8')

# Get the stored encoding
print(request$getEncoding())
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-getCurlOptions"></a>}}
\if{latex}{\out{\hypertarget{method-Request-getCurlOptions}{}}}
\subsection{Method \code{getCurlOptions()}}{
Gets the options object to pass to cURL library.

Make a RCurl::CURLOptions object by calling RCurl::curlOptions()
function. Useragent, header and body are passed as options if not NULL.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$getCurlOptions(useragent = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{useragent}}{The user agent as a character value, or NULL.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An RCurl::CURLOptions object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a POST Request object for the records-batch-post webservice of
# ChemSpider database
request <- sched::Request$new(
  url=sched::URL$new(c('https://api.rsc.org/compounds/v1/', 'records',
                       'batch')),
  method='post', header=c('Content-Type'="", apikey='my-token'),
  body='{"recordIds": [2], "fields": ["SMILES","Formula","InChI"]}')

# Get the associated RCurl options object
rcurl_opts <- request$getCurlOptions('myapp ; me@my.address')

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-getUniqueKey"></a>}}
\if{latex}{\out{\hypertarget{method-Request-getUniqueKey}{}}}
\subsection{Method \code{getUniqueKey()}}{
Gets a unique key to identify this request.

The key is an MD5 sum computed from the string representation of this
request.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$getUniqueKey()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A unique key as an MD5 sum.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a GET request
request <- sched::Request$new(sched::URL$new('https://peakforest.org/'))

# Get the MD5 sum of this request
print(request$getUniqueKey())

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-getHeaderAsSingleString"></a>}}
\if{latex}{\out{\hypertarget{method-Request-getHeaderAsSingleString}{}}}
\subsection{Method \code{getHeaderAsSingleString()}}{
Gets the HTTP header as a string, concatenating all its information
into a single string.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$getHeaderAsSingleString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The header as a single character value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a POST Request object for the records-batch-post webservice of
# ChemSpider database
request <- sched::Request$new(
  url=sched::URL$new(c('https://api.rsc.org/compounds/v1/', 'records',
                       'batch')),
  method='post', header=c('Content-Type'="", apikey='my-token'),
  body='{"recordIds": [2], "fields": ["SMILES","Formula","InChI"]}')

# Get back the POST header as a single string
print(request$getHeaderAsSingleString())

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-getBody"></a>}}
\if{latex}{\out{\hypertarget{method-Request-getBody}{}}}
\subsection{Method \code{getBody()}}{
Gets the body.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$getBody()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The body as a single character value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a POST Request object for the records-batch-post webservice of
# ChemSpider database
request <- sched::Request$new(
  url=sched::URL$new(c('https://api.rsc.org/compounds/v1/', 'records',
                       'batch')),
  method='post', header=c('Content-Type'="", apikey='my-token'),
  body='{"recordIds": [2], "fields": ["SMILES","Formula","InChI"]}')

# Get back the POST body
print(request$getBody())

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-print"></a>}}
\if{latex}{\out{\hypertarget{method-Request-print}{}}}
\subsection{Method \code{print()}}{
Displays information about this instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
self as invisible.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a GET request
request <- sched::Request$new(sched::URL$new('https://peakforest.org/'))

# Print the Request object
print(request)

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-toString"></a>}}
\if{latex}{\out{\hypertarget{method-Request-toString}{}}}
\subsection{Method \code{toString()}}{
Gets a string representation of this instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$toString()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A single string giving a representation of this instance.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{# Create a GET request
request <- sched::Request$new(sched::URL$new('https://peakforest.org/'))

# Get the string representation of this request
print(request$toString())

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Request-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Request-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Request$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
