% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apastat.R
\name{apastat}
\alias{apastat}
\title{Format simple statistic test results for scientific publication}
\usage{
apastat(test, roundN = 2, es = c(TRUE, FALSE), ci = c(TRUE, FALSE), var = NULL)
}
\arguments{
\item{test}{The \code{stats::t.test}, \code{stats::cor.test},
or \code{stats::lm} object to be formatted.}

\item{roundN}{The number of decimal places to
round all output to (default=2).}

\item{es}{Include effect side (Cohen's d for t-test or
2-level factor lm variable), default to TRUE.}

\item{ci}{Include confidence interval of estimate, default to TRUE.}

\item{var}{Only for lm object, select name of variable to
summarize (default=NULL), if NULL, will summarize overall model fit.}
}
\value{
Output formatted statistics
}
\description{
The \code{apastat} function summarizes statistic test
results scientific publication.
This currently will take \code{stats::t.test},
\code{stats::cor.test}, or \code{stats::lm} results as input.
The output is intended to be included as
in-text parenthetical statistics in publication.
}
\examples{
apastat(stats::cor.test(psydat$Age, psydat$Height))
apastat(stats::t.test(Height ~ Sex, data = psydat))
apastat(stats::lm(data = psydat, Height ~ Age + Sex))
apastat(stats::lm(data = psydat, Height ~ Age + Sex), var = "Age")

}
