% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{analyzeClones}
\alias{analyzeClones}
\title{Clonal assignment analysis}
\usage{
analyzeClones(db, junction = "JUNCTION", v_call = "V_CALL",
  j_call = "J_CALL", clone = "CLONE", first = FALSE, cdr3 = FALSE,
  nproc = 1, progress = FALSE)
}
\arguments{
\item{db}{data.frame with Change-O style columns containing sequence data.}

\item{junction}{name of the column containing nucleotide sequences to compare.
Also used to determine sequence length for grouping.}

\item{v_call}{name of the column containing the V-segment allele calls.}

\item{j_call}{name of the column containing the J-segment allele calls.}

\item{clone}{name of the data column containing clone identifiers.}

\item{first}{if \code{TRUE} only the first call of the gene assignments
is used. if \code{FALSE} the union of ambiguous gene
assignments is used to group all sequences with any
overlapping gene calls.}

\item{cdr3}{if \code{TRUE} remove 3 nts from both ends of \code{junction}
(converts IMGT junction to CDR3 region).}

\item{nproc}{number of cores to distribute the function over.}

\item{progress}{if \code{TRUE} print a progress bar.}
}
\value{
Returns a \link{ClonalAnalysis} object.
}
\description{
The \code{analyzeClones} function performs a series of analysis to assess the performance of
\code{defineClonesScoper} function.
}
\note{
Arguments \code{first} and \code{cdr3} must match the corresponding arguments
used in the \link{defineClonesScoper} function.
}
\examples{
# Clonal assignment analysis
results <- analyzeClones(ClonedExampleDb, junction = "JUNCTION", v_call = "V_CALL",
                          j_call = "J_CALL", clone = "CLONE", first = TRUE)
# print threshold (a numeric)
results@threshold

# get inter and intra conal distances (a data.frame)
df <- results@inter_intra[[1]]

# density plot of inter versus intra clonal distances  (a ggplot).
results@plot_inter_intra

# get the neighborhoods used in spectral clustering (a numeric vector).
ngs <- results@neighborhoods

# plot histogram of neighborhoods (a ggplot).
results@plot_neighborhoods
}
