% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scorecard.R
\name{scorecard}
\alias{scorecard}
\title{Creating a Scorecard}
\usage{
scorecard(bins, model, points0 = 600, odds0 = 1/19, pdo = 50)
}
\arguments{
\item{bins}{Binning information generated from \code{woebin} function.}

\item{model}{A glm model object.}

\item{points0}{Target points, default 600.}

\item{odds0}{Target odds, default 1/19. Odds = p/(1-p).}

\item{pdo}{Points to Double the Odds, default 50.}
}
\value{
scorecard
}
\description{
\code{scorecard} creates a scorecard based on the results from \code{woebin} and \code{glm}.
}
\examples{
library(data.table)
library(scorecard)

# Traditional Credit Scoring Using Logistic Regression
# load germancredit data
data("germancredit")

# random subset 10 x variables
# rename creditability as y
dt <- setDT(germancredit)[, c(sample(20, 10), 21)][, `:=`(
  y = ifelse(creditability == "bad", 1, 0),
  creditability = NULL
)]

# woe binning ------
bins <- woebin(dt, "y")
dt_woe <- woebin_ply(dt, bins)

# glm ------
m <- glm( y ~ ., family = "binomial", data = dt_woe)
# summary(m)

\dontrun{
# Select a formula-based model by AIC
m_step <- step(m, direction="both")
m <- eval(m_step$call)
# summary(m)

# performance ------
# predicted proability
# dt_woe$pred <- predict(m, type='response', dt_woe)

# performace
# ks & roc plot
# perf_plot(dt_woe$y, dt_woe$pred)
}

# card
card <- scorecard(bins, m)

# score
# only total score
score1 <- scorecard_ply(dt, card)

\dontrun{
# credit score for both total and each variable
score2 <- scorecard_ply(dt, card, only_total_score = F)
}
}
\seealso{
\code{\link{scorecard_ply}}
}
