% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{num_to_cat}
\alias{num_to_cat}
\title{Binning numerical variables based on cuts from IV table}
\usage{
num_to_cat(base, num_woe_table, num_missing = -99999)
}
\arguments{
\item{base}{input dataframe}

\item{num_woe_table}{num_woe_table class from iv table output}

\item{num_missing}{(optional) imputed missing value for numerical variable (default value is -99999)}
}
\value{
The function returns a dataframe after converting the numerical variables into categorical classes.
}
\description{
The function takes the num_woe_table output from a class "iv_table". Based on the split points from the num_woe_table, the numerical variables are binned into categories.
}
\examples{
data <- iris
data$Y <- sample(0:1,size=nrow(data),replace=TRUE)
x <- c("Sepal.Length","Sepal.Width","Petal.Length","Petal.Width")
iv_table_list <- iv_table(base = data,target = "Y",num_var_name = x,cat_var_name = "Species")
num_cat <- num_to_cat(base = data,num_woe_table = iv_table_list$num_woe_table)
}
\author{
Arya Poddar <aryapoddar290990@gmail.com>
}
