% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_forecasts.R
\name{check_forecasts}
\alias{check_forecasts}
\title{Check forecasts}
\usage{
check_forecasts(data)
}
\arguments{
\item{data}{data.frame with predictions in the same format required for
\code{\link[=score]{score()}}.}
}
\value{
A list with elements that give information about what \code{scoringutils}
thinks you are trying to do and potential issues.
\itemize{
\item \code{target_type} the type of the prediction target as inferred from the
input: 'binary', if all values in \code{true_value} are either 0 or 1 and values
in \code{prediction} are between 0 and 1, 'discrete' if all true values are
integers.
and 'continuous' if not.
\item \code{prediction_type} inferred type of the prediction. 'quantile', if there is
a column called 'quantile', else 'discrete' if all values in \code{prediction}
are integer, else 'continuous.
\item \code{forecast_unit} unit of a single forecast, i.e. the grouping that uniquely
defines a single forecast. This is assumed to be all
present columns apart from the following protected columns:
\code{c("prediction", "true_value", "sample", "quantile","range", "boundary")}.
It is important that you remove all unnecessary columns before scoring.
\item \code{rows_per_forecast} a data.frame that shows how many rows (usually
quantiles or samples there are available per forecast. If a forecast model
has several entries, then there a forecasts with differing numbers of
quantiles / samples.
\item \code{unique_values} A data.frame that shows how many unique values there are
present per model and column in the data. This doesn't directly show missing
values, but rather the maximum number of unique values across the whole data.
\item \code{warnings} A vector with warnings. These can be ignored if you know what
you are doing.
\item \code{errors} A vector with issues that will cause an error when running
\code{\link[=score]{score()}}.
\item \code{messages} A verbal explanation of the information provided above.
}
}
\description{
Function to check the input data before running
\code{\link[=score]{score()}}.

The data should come in one of three different formats:
\itemize{
\item A format for binary predictions (see \link{example_binary})
\item A sample-based format for discrete or continuous predictions
(see \link{example_continuous} and \link{example_integer})
\item A quantile-based format (see \link{example_quantile})
}
}
\examples{
check <- check_forecasts(example_quantile)
print(check)
check_forecasts(example_binary)
}
\seealso{
Function to move from sample-based to quantile format:
\code{\link[=sample_to_quantile]{sample_to_quantile()}}
}
\author{
Nikos Bosse \email{nikosbosse@gmail.com}
}
\keyword{check-forecasts}
