\name{A4. Define bivariate Spline}
\alias{A4. Define bivariate Spline}
\alias{s2D}
\title{
Bivariate spline
}
\description{
Define a bivariate spline using tensor products or thin plate splines.
}
\usage{
s2D(data = NULL, penalty = c("none",  "cs",  "ps",  "tps"),
        is.X = c("none",  "tensor",  "tps"), intercept = TRUE,
        ps.order = 2, aniso.angle = 0, aniso.ratio = 1,
        env = .GlobalEnv, ...)
}
\arguments{
	\item{data}{
		sss object. Data of class sss generated by \link{as.sss} or \link{create.sss}.
	}
	\item{penalty}{
		character. Type of spline to use and penalty to define. One of \samp{cs} or \samp{ps} for cubic splines based on tensor products, \samp{tps} for thin plate splines or \samp{none}. \samp{cs} define the penalty based on roughness matrices of natural cubic splines while \samp{ps} define the penalty based on differences of order \code{ps.order}. See \link{scp}. If \code{penalty="none"} then no spline nor penalty are defined and the model for the spatial surface is defined by \code{is.X}.
	}
	\item{is.X}{
		character. Model for the spatial surface. One of \samp{tensor}, \samp{tps} or \samp{none}. Only required if \code{penalty="none"}. See details.
	}
	\item{intercept}{
		logical. Define whether to include an intercept or not. Default to \code{TRUE}.
	}
	\item{ps.order}{
		integer. Order for differences if \code{penalty = "ps"}.
	}
	\item{aniso.angle}{
		numeric. Angle for geometric anisotropy.
	}
	\item{aniso.ratio}{
		numeric. Ratio between \eqn{[0,1]} for geometric anisotropy.
	}
	\item{env}{
		environment. Where to search for data if \code{data=NULL}.
	}
	\item{\dots}{
		additional arguments. Not required.
	}

}
\details{
Note that \code{is.X} is only needed if \code{penalty="none"}. By defining \code{is.X="none"} it only define an intercept (if \code{intercept=TRUE}), \code{is.X="tps"} defines an intercept, coordinate 1, and coordinate 2 as covariates, while \code{is.X="tensor"} defines also the interaction coordinate 1*coordinate 2. See \link{scp}.
}
\author{
Mario A. Martinez Araya, \email{r@marioma.me}
}
%% ~Make other sections like Warning with \section{Warning }{....} ~ 

