% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{jaccard_indicator_comp}
\alias{jaccard_indicator_comp}
\title{Perform the computations for thresholded Jaccard distance}
\usage{
jaccard_indicator_comp(gs, eps)
}
\arguments{
\item{gs}{a list of integer vectors, one for each row, giving the column
indices of the non-zero elements of the row or \code{NULL} if the
whole row is empty.}

\item{eps}{an upper bound on the Jaccard distance (\code{1 - eps} becomes a
lower bound on the Jaccard similarity)}
}
\value{
A list with row and column indices in the #row x #row indicator
matrix specifying which rows in the original matrix had a distance
of at most \code{eps}.
}
\description{
Perform the computations for thresholded Jaccard distance
}
\details{
This function is optimized for sparse matrices and computes the pairwise
Jaccard distances between the rows of the input matrix. Note that the
actual distance is not saved. Instead, a threshold (\code{eps}) is supplied
and an indicator matrix is returned, with a one indicating that the
distance is smaller than \code{eps} (equivalently, the Jaccard similarity
is larger than \code{1 - eps}).
}
\keyword{internal}
