% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperparlin.r
\name{hyperparlin}
\alias{hyperparlin}
\title{Find Scale Parameter for Inverse Gamma Hyperprior of Linear Effects with Spike and Slab Prior}
\usage{
hyperparlin(alpha1 = 0.1, alpha2 = 0.1, c1 = 0.1, c2 = 0.1,
  eps = .Machine$double.eps, a = 5)
}
\arguments{
\item{alpha1}{denotes the 1-\eqn{\alpha1} level for \eqn{b}.}

\item{alpha2}{denotes the 1-\eqn{\alpha2} level for \eqn{r}.}

\item{c1}{denotes the expected range of the linear effect in the slab part.}

\item{c2}{denotes the expected range of the linear effect in the spike part.}

\item{eps}{denotes the error tolerance of the result, default is \code{.Machine$double.eps}.}

\item{a}{is the shape parameter of the inverse gamma distribution, default is 5.}
}
\value{
an object of class \code{list} with root values \eqn{r}, \eqn{b} from \code{\link{uniroot}}.
}
\description{
This function implements a optimisation routine that computes the scale parameter \eqn{b} and selection parameter
\eqn{r}. Here, we assume an inverse gamma prior IG(\eqn{a},\eqn{b}) for \eqn{\tau^2} and \eqn{\beta|\delta,\tau^2\sim N(0,r(\delta)\tau^2)}. 
For given shape paramter \eqn{a} the user gets \eqn{b}, \eqn{r}
such that approximately \eqn{P(\beta\le c2|spike)\ge 1-\alpha2} and \eqn{P(\beta\ge c1|slab)\ge 1-\alpha1} hold.\cr
Note that if you observe numerical instabilities try not to specify \eqn{\alpha1} and \eqn{\alpha2} smaller than 0.1.
}
\section{Warning}{

\eqn{\alpha1} and \eqn{\alpha2} should not be smaller than 0.1 due to numerical sensitivity and possible instability. Better change \eqn{c1}, \eqn{c2}.
}

\examples{
set.seed(123)
result <- hyperparlin()
r <- result$r
b <- result$b

hyperparlin(alpha1=0.1,alpha2=0.1,c1=0.5,c2=0.1,a=5) 

}
\references{
Nadja Klein, Thomas Kneib, Stefan Lang and Helga Wagner (2016). Automatic Effect Selection in Distributional Regression via Spike and Slab Priors. 
\emph{Working Paper}.
}
\author{
Nadja Klein
}
