% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LLmodGlobalRisk.R
\docType{methods}
\name{LLmodGlobalRisk}
\alias{LLmodGlobalRisk}
\alias{LLmodGlobalRisk,ANY-method}
\alias{LLmodGlobalRisk,data.frame-method}
\alias{LLmodGlobalRisk,matrix-method}
\alias{LLmodGlobalRisk,sdcMicroObj-method}
\alias{LLmodGlobalRisk-methods}
\title{Global risk using log-linear models.}
\usage{
LLmodGlobalRisk(obj, method = "IPF", inclProb = NULL, form = NULL,
  modOutput = FALSE)
}
\arguments{
\item{obj}{An object of class sdcMicroObj or a numeric matrix or data frame
containing the categorical key variables.}

\item{method}{At this time, only iterative proportional fitting
(\dQuote{IPF}) can be used.}

\item{inclProb}{Inclusion probabilites (experimental)}

\item{form}{A formula specifying the model.}

\item{modOutput}{If TRUE, additional output is given.}
}
\value{
Two global risk measures or the modified risk in the \code{\link{sdcMicroObj-class}} object.
}
\description{
The sample frequencies are assumed to be independent and following a Poisson
distribution. The parameters of the corresponding parameters are estimated
by a log-linear model including the main effects and possible interactions.
}
\details{
This measure aims to (1) calculate the number of sample uniques that are
population uniques with a probabilistic Poisson model and (2) to estimate
the expected number of correct matches for sample uniques.

ad 1) this risk measure is defined over all sample uniques (SU) as \deqn{
\tau_1 = \sum\limits_{SU} P(F_k=1 | f_k=1) \quad , } i.e. the expected
number of sample uniques that are population uniques.

ad 2) this risk measure is defined over all sample uniques (SU) as \deqn{
\tau_2 = \sum\limits_{SU} P(F_k=1 | f_k=1) \quad , CORRECT! }

Since population frequencies \eqn{F_k} are unknown, they has to be
estimated.

The iterative proportional fitting method is used to fit the parameters of
the Poisson distributed frequency counts related to the model specified to
fit the frequency counts.  The obtained parameters are used to estimate a
global risk, defined in Skinner and Holmes (1998).
}
\note{
LLmodGlobalRisk is depcrecated for \code{\link{modRisk}} and is only
provided for compatibility with older versions of this package. It may be removed
in future versions.
}
\author{
Matthias Templ
}
\references{
Skinner, C.J. and Holmes, D.J. (1998) \emph{Estimating the
re-identification risk per record in microdata}. Journal of Official
Statistics, 14:361-372, 1998.

Rinott, Y. and Shlomo, N. (1998). \emph{A Generalized Negative Binomial
Smoothing Model for Sample Disclosure Risk Estimation}. Privacy in
Statistical Databases. Lecture Notes in Computer Science.  Springer-Verlag,
82--93.
}
\seealso{
\code{\link{loglm}}, \code{\link{measure_risk}}

\code{\link{modRisk}}
}
\keyword{manip}

