% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/localSuppression.R
\docType{methods}
\name{localSuppression}
\alias{kAnon}
\alias{kAnon,data.frame-method}
\alias{kAnon,matrix-method}
\alias{kAnon,sdcMicroObj-method}
\alias{kAnon-methods}
\alias{localSuppression}
\alias{localSuppression,data.frame-method}
\alias{localSuppression,matrix-method}
\alias{localSuppression,sdcMicroObj-method}
\alias{localSuppression-methods}
\title{Local Suppression to obtain k-anonymity}
\usage{
localSuppression(obj, k = 2, importance = NULL, combs = NULL, ...)
}
\arguments{
\item{obj}{an object of class sdcMicroObj or a data frame or matrix}

\item{k}{threshold for k-anonymity}

\item{importance}{numeric vector of numbers between 1 and n (n=length of
vector keyVars).  This vector represents the "importance" of variables that
should be used for local suppression in order to obtain k-anonymity.
key-variables with importance=1 will - if possible - not suppressed,
key-variables with importance=n will be used whenever possible.}

\item{combs}{numeric vector. if specified, the algorithm will provide k-anonymity
for each combination of n key variables (with n being the value of the ith element
of this parameter. For example, if combs=c(4,3), the algorithm will provide
k-anonymity to all combinations of 4 key variables and then k-anonymity to all
combinations of 3 key variables. It is possible to apply different k to these
subsets by specifying k as a vector. If k has only one element, the same value
of k will be used for all subgroups.}

\item{...}{see arguments below
\itemize{
\item{keyVars}{numeric vector specifying indices of (categorical) key-variables}
\item{strataVars}{numeric vector specifying indices of variables that should be used
for stratification within 'obj'}}}
}
\value{
Manipulated data set with suppressions that has k-anonymity with
respect to specified key-variables or the manipulated data stored in the
\code{\link{sdcMicroObj-class}}.
}
\description{
Algorithm to achieve k-anonymity by performing local suppression.
}
\details{
The algorithm provides a k-anonymized data set by suppressing values in key
variables. The algorithm tries to find an optimal solution to suppress as
few values as possible and considers the specified importance vector. If not
specified, the importance vector is constructed in a way such that key
variables with a high number of characteristics are considered less
important than key variables with a low number of characteristics.

The implementation provides k-anonymity per strata, if slot 'strataVar' has
been set in \code{\link{sdcMicroObj-class}} or if parameter 'strataVar' is
used when appying the data.frame- or matrix method. For details, have a look
at the examples provided.
}
\note{
Deprecated methods 'localSupp2' and 'localSupp2Wrapper' are no longer available
in sdcMicro > 4.5.0.
\code{kAnon} is a more intutitive term for localSuppression because the aim is always
to obtain k-anonymity for some parts of the data.
}
\section{Methods}{
 \describe{
\item{list("signature(obj = \"data.frame\")")}{}
\item{list("signature(obj = \"matrix\")")}{}
\item{list("signature(obj = \"sdcMicroObj\")")}{}}
}
\examples{
\dontrun{
data(francdat)
## Local Suppression
localS <- localSuppression(francdat, keyVar=c(4,5,6))
localS
plot(localS)

## for objects of class sdcMicro, no stratification
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- localSuppression(sdc)

## for objects of class sdcMicro, no with stratification
testdata2$ageG <- cut(testdata2$age, 5, labels=paste0("AG",1:5))
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight',
  strataVar='ageG')
sdc <- localSuppression(sdc)

## it is also possible to provide k-anonymity for subsets of key-variables
## with different parameter k!
## in this case we want to provide 10-anonymity for all combinations
## of 5 key variables, 20-anonymity for all combinations with 4 key variables
## and 30-anonymity for all combinations of 3 key variables.
## note: stratas are automatically considered!
combs <- 5:3
k <- c(10,20,30)
sdc <- localSuppression(sdc, k=k, combs=combs)

## data.frame method (no stratification)
keyVars <- c("urbrur","roof","walls","water","electcon","relat","sex")
strataVars <- c("ageG")
inp <- testdata2[,c(keyVars, strataVars)]
ls <- localSuppression(inp, keyVars=1:7)
print(ls)
plot(ls)

## data.frame method (with stratification)
ls <- kAnon(inp, keyVars=1:7, strataVars=8)
print(ls)
plot(ls, showTotalSupps=TRUE)
}
}
\author{
Bernhard Meindl, Matthias Templ
}
\keyword{manip}

