% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GUIfunctions.R
\name{selectHouseholdData}
\alias{selectHouseholdData}
\title{Creates a household level file from a dataset with a household structure.}
\usage{
selectHouseholdData(dat, hhId, hhVars)
}
\arguments{
\item{dat}{a data.frame with the full dataset}

\item{hhId}{name of the variable with the household (cluster) ID}

\item{hhVars}{character vector with names of all household level variables}
}
\value{
a data.frame with only household level variables and one record per household
}
\description{
It removes individual level variables and selects one record per household based on a household ID. The function can also be used for other hierachical structures.
}
\note{
It is of great importance that users select a variable with containing information on household-ids and weights in \code{hhVars}.
}
\examples{
## ori-hid: household-ids; household_weights: sampling weights for households
x_hh <- selectHouseholdData(dat=testdata, hhId="ori_hid",
  hhVars=c("urbrur", "roof",  "walls", "water", "electcon", "household_weights"))
}
\author{
Thijs Benschop and Bernhard Meindl
}

