% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suda2.R
\docType{methods}
\name{suda2}
\alias{suda2}
\title{Suda2: Detecting Special Uniques}
\usage{
suda2(obj, ...)
}
\arguments{
\item{obj}{object of class \code{data.frame} or a \code{\link{sdcMicroObj-class}}-object}

\item{...}{see arguments below
\itemize{
\item{\code{variables}: }{Categorical (key) variables. Either the column names or and
index of the variables to be used for risk measurement.}
\item{\code{missing}: }{Missing value coding in the given data set.}
\item{\code{DisFraction}: }{It is the sampling fraction for the simple random
sampling, and the common sampling fraction for stratified sampling. By
default, it's set to 0.01.}
\item{\code{original_scores}: }{if this argument is \code{TRUE} (the default), the suda-scores are computed as described in paper
"SUDA: A Program for Detecting Special Uniques" by Elliot et al., if \code{FALSE}, the computation of the scores
is slightly different as it was done in the original implementation of the algorithm by the IHSN.}
}}
}
\value{
A modified \code{\link{sdcMicroObj-class}} object or the following list
\itemize{
\item{\code{ContributionPercent}: }{The contribution of each key variable to the SUDA
score, calculated for each row.}
\item{\code{score}: }{The suda score.}
\item{\code{disscore}: }{The dis suda score}
\item{\code{attribute_contributions: }}{\code{data.frame} showing how much of the total risk is contributed
by each variable. This information is stored in a \code{data.frame} in two variables:
\itemize{
 \item \code{variable}: containing the name of the variable
 \item \code{contribution}: contains how much risk a variable contributes to the total risk.
}}
\item{\code{attribute_level_contributions: }}{shows risks of each attribute-level. this is saved in a
\code{data.frame} with three columns.
\itemize{
 \item \code{variable}: containing the name of the variable
 \item \code{attribute}: holding relevant level-codes and
 \item \code{contribution}: contains the risk of this level within the variable.)
 }
}}
}
\description{
SUDA risk measure for data from (stratified) simple random sampling.
}
\details{
Suda 2 is a recursive algorithm for finding Minimal Sample Uniques. The
algorithm generates all possible variable subsets of defined categorical key
variables and scans them for unique patterns in the subsets of variables.
The lower the amount of variables needed to receive uniqueness, the higher
the risk of the corresponding observation.
}
\note{
Since version >5.0.2, the computation of suda-scores has changed and is now by default as described in
the original paper by Elliot et al.
}
\examples{
\dontrun{
data(testdata2)
data_suda2 <- suda2(testdata2,variables=c("urbrur","roof","walls","water","sex"))
data_suda2
str(data_suda2)
summary(data_suda2)

## for objects of class sdcMicro:
data(testdata2)
sdc <- createSdcObj(testdata2,
  keyVars=c('urbrur','roof','walls','water','electcon','relat','sex'),
  numVars=c('expend','income','savings'), w='sampling_weight')
sdc <- suda2(sdc, original_scores=FALSE)
}
}
\references{
C. J. Skinner; M. J. Elliot (20xx) A Measure of Disclosure Risk
for Microdata. \emph{Journal of the Royal Statistical Society: Series B
(Statistical Methodology)}, Vol. 64 (4), pp 855--867.

M. J. Elliot, A. Manning, K. Mayes, J. Gurd and M. Bane (20xx) SUDA: A
Program for Detecting Special Uniques, Using DIS to Modify the
Classification of Special Uniques

Anna M. Manning, David J. Haglin, John A. Keane (2008) A recursive search
algorithm for statistical disclosure assessment. \emph{Data Min Knowl Disc}
16:165 -- 196

Templ, M. Statistical Disclosure Control for Microdata: Methods and Applications in R.
\emph{Springer International Publishing}, 287 pages, 2017. ISBN 978-3-319-50272-4.
\doi{10.1007/978-3-319-50272-4}
}
\author{
Alexander Kowarik and Bernhard Meindl (based on the C++ code from the Organisation For
Economic Co-Operation And Development.

For the C++ code: This work is being supported by the International
Household Survey Network and funded by a DGF Grant provided by the World
Bank to the PARIS21 Secretariat at the Organisation for Economic
Co-operation and Development (OECD). This work builds on previous work which
is elsewhere acknowledged.
}
\keyword{manip}
