% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{sdcHashClass-class}
\alias{initialize,sdcHashClass-method}
\alias{sdcHashClass-class}
\title{S4 Hash Class}
\usage{
\S4method{initialize}{sdcHashClass}(.Object, ...)
}
\arguments{
\item{.Object}{A \code{\linkS4class{sdcHashingDefinitionClass}} object.}

\item{...}{The optional parameters specifying the data
and other options.}
}
\description{
This class defines the data hash that is used to identify
  cells to be targeted for statistical disclosure control.
}
\details{
The hashing definition presently handles only categorical
  fields, which limits the applicability of this software
  accordingly.

Does not currently permit use of an arbitrary hashing definition.
}
\section{Methods (by generic)}{
\itemize{
\item \code{initialize}: 
}}
\section{Slots}{

\describe{
\item{\code{.Data}}{A matrix.}

\item{\code{Hdef}}{The hashing definition on which the
\code{\linkS4class{sdcHashClass}} object is built.}

\item{\code{forward}}{Logical indicating whether a forward hash or a backward
hash, in terms of field order, has been used.}

\item{\code{hash}}{A character string containing one hash representation
for each data record.}
}}
\examples{
new("sdcHashClass")
new("sdcHashClass")
my.X <- data.frame(matrix(ifelse(runif(5000)>.5, TRUE, FALSE), ncol = 50))
new("sdcHashClass", X = my.X)
new("sdcHashClass", X = my.X, na.recode = FALSE, which = 2:4,
    forwardHashing = TRUE)
}

