% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{sigmaDiff}
\alias{sigmaDiff}
\title{High-frequency estimate of the diffusion matrix}
\usage{
sigmaDiff(data, delta, circular = TRUE, diagonal = FALSE, isotropic = FALSE)
}
\arguments{
\item{data}{vector or matrix of size \code{c(N, p)} containing the discretized process.}

\item{delta}{discretization step.}

\item{circular}{whether the process is circular or not.}

\item{diagonal, isotropic}{enforce different constraints for the diffusion matrix.}
}
\value{
The estimated diffusion matrix of size \code{c(p, p)}.
}
\description{
Estimation of the \eqn{\Sigma} in the multivariate diffusion
\deqn{dX_t=b(X_t)dt+\Sigma dW_t}{dX_t=b(X_t)dt+\Sigma dW_t}
by the high-frequency estimate
\deqn{\hat\Sigma = \frac{1}{N\Delta}\sum_{i=1}^N(X_i-X_{i-1})(X_i-X_{i-1})^T}{\hat\Sigma = \frac{1}{N\Delta}\sum_{i=1}^N(X_i-X_{i-1})(X_i-X_{i-1})^T.}
}
\details{
See Section 3.1 in García-Portugués et al. (2019) for details.
}
\examples{
# 1D
x <- drop(euler1D(x0 = 0, alpha = 1, mu = 0, sigma = 1, N = 1000,
                  delta = 0.01))
sigmaDiff(x, delta = 0.01)

# 2D
x <- t(euler2D(x0 = rbind(c(pi, pi)), A = rbind(c(2, 1), c(1, 2)),
               mu = c(pi, pi), sigma = c(1, 1), N = 1000,
               delta = 0.01)[1, , ])
sigmaDiff(x, delta = 0.01)
sigmaDiff(x, delta = 0.01, circular = FALSE)
sigmaDiff(x, delta = 0.01, diagonal = TRUE)
sigmaDiff(x, delta = 0.01, isotropic = TRUE)
}
\references{
García-Portugués, E., Sørensen, M., Mardia, K. V. and Hamelryck, T. (2019) Langevin diffusions on the torus: estimation and applications. \emph{Statistics and Computing}, 29(2):1--22. \doi{10.1007/s11222-017-9790-2}
}
