% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmi.R
\name{lmi1}
\alias{lmi1}
\title{Linear Matrix Inequality 1}
\usage{
lmi1(B)
}
\arguments{
\item{B}{An mxn real valued matrix}
}
\value{
Returns an object of class sqlp_input, containing the following:

\item{blk}{A matrix object describing the block diagonal structure of the SQLP data}
\item{At}{A matrix object containing constraint matrices for the primal-dual problem}
\item{C}{A matrix object containing the constant c matrices in the primal objective function}
\item{b}{A vector containing the right hand side of the equality constraints in the primal problem}
\item{OPTIONS}{A list object specifying the value of parbarrier}
}
\description{
\code{lmi1} creates input for sqlp to solve a linear matrix inequality problem
}
\details{
Solves the type-1 linear matrix inequality problem. Mathematical and implementation
details can be found in the vignette
}
\examples{
B <- matrix(c(-1,5,1,0,-2,1,0,0,-1), nrow=3)

out <- lmi1(B)
blk <- out$blk
At <- out$At
C <- out$C
b <- out$b

}

